/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.model.plugin.AuthenticationSelector;
import com.pingidentity.admin.api.model.plugin.AuthenticationSelectorAttribute;
import com.pingidentity.admin.api.model.plugin.ConfigField;
import com.pingidentity.admin.api.model.plugin.ConfigTable;
import com.pingidentity.admin.api.model.plugin.PluginInstance;
import com.pingidentity.admin.api.translator.plugin.PluginConfigTranslator;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.PluginConfigValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.validation.CommonValidator;

public class PluginInstanceValidator
extends CompositeValidator {
    protected final PluginInstance apiInstance;
    protected final PluginManager<?, ?> pluginManager;
    protected final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    protected final boolean isCreate;
    protected final PluginEnum pluginType;
    protected PluginDescriptor pluginDescriptor;
    protected String parentId = null;
    protected Configuration domainConfiguration = null;
    protected ValidatorContext validatorContext;

    public PluginInstanceValidator(PluginInstance apiInstance, PluginManager<?, ?> manager, boolean isCreate, PluginEnum pluginType, ValidatorContext validatorContext) {
        this.apiInstance = apiInstance;
        this.pluginManager = manager;
        this.isCreate = isCreate;
        this.pluginType = pluginType;
        this.validatorContext = validatorContext;
    }

    protected boolean doSuperValidate() {
        return super.validate();
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validateId();
        this.validateName();
        this.validatePluginDescriptorRef();
        this.validateParent();
        this.validateConfiguration();
        return !this.hasErrors();
    }

    protected void validateId() {
        if (this.pluginType.supportsMultipleInstancesPerType() && this.isCreate) {
            if (StringUtils.isBlank((String)this.apiInstance.getId())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_id_required, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getId())));
            } else if (!CommonValidator.isValidAdapterInstanceId((String)this.apiInstance.getId())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_id_invalid, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getId()), new Object[]{33}));
            } else if (this.pluginManager.isDuplicateId(this.apiInstance.getId())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_id_in_use, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getId())));
            }
        }
    }

    protected void validateName() {
        if (this.pluginType.supportsMultipleInstancesPerType()) {
            if (StringUtils.isBlank((String)this.apiInstance.getName())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_name_required, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getName())));
            } else {
                for (ConfigurablePluginInstance instance : this.pluginManager.getInstances()) {
                    if (instance.getId().equals(this.apiInstance.getId()) || !instance.getName().equals(this.apiInstance.getName())) continue;
                    this.appendError(this.errorFactory.create(ApiMessageKey.plugin_name_in_use, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getName())));
                    break;
                }
                for (ConfigurablePluginInstance instance : this.pluginManager.getVirtualInstances()) {
                    if (instance.getId().equals(this.apiInstance.getId()) || !instance.getName().equals(this.apiInstance.getName())) continue;
                    this.appendError(this.errorFactory.create(ApiMessageKey.plugin_name_in_use, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getName())));
                    break;
                }
            }
        }
    }

    protected void validatePluginDescriptorRef() {
        if (this.apiInstance.getPluginDescriptorRef() == null || this.apiInstance.getPluginDescriptorRef().getId() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_required, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getPluginDescriptorRefId())));
        } else {
            this.pluginDescriptor = PluginInstanceValidator.getDescriptorByClassName(this.pluginManager, this.apiInstance.getPluginDescriptorRef().getId());
            if (this.pluginDescriptor == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_invalid, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getPluginDescriptorRefId())));
            }
        }
    }

    protected void validateParent() {
        if (this.pluginType.supportsMultipleInstancesPerType()) {
            if (this.apiInstance.getParentRef() != null) {
                if (this.pluginType.supportsPluginHierarchies()) {
                    String parentRefId = this.apiInstance.getParentRef().getId();
                    ConfigurablePluginInstance parentInstance = null;
                    if (parentRefId != null) {
                        parentInstance = this.pluginManager.getInstance(parentRefId);
                    } else {
                        this.appendError(this.errorFactory.create(ApiMessageKey.plugin_parent_id_required, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getPluginParentId())));
                    }
                    if (parentInstance != null && parentInstance.getId().equals(parentRefId)) {
                        List parentAncestorIDs = ConfigurationUtil.getAncestorIDs((ConfigurablePluginInstance)parentInstance, this.pluginManager);
                        if (this.apiInstance.getId() != null && (this.apiInstance.getId().equals(parentRefId) || this.isApiInstanceAnAncestorOfItsParent(this.apiInstance.getId(), parentAncestorIDs))) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_parent_id_restriction, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getPluginParentId()), new Object[]{parentRefId}));
                        }
                        String parentClassName = parentInstance.getDescriptor().getPluginClassName();
                        if (this.apiInstance.getPluginDescriptorRef() == null || !parentClassName.equals(this.apiInstance.getPluginDescriptorRef().getId())) {
                            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_parent_descriptor_mismatch, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getPluginParentId())));
                        } else {
                            this.parentId = parentRefId;
                        }
                    } else if (parentRefId != null) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.plugin_parent_id_not_found, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getPluginParentId())));
                    }
                } else {
                    this.appendError(this.errorFactory.create(ApiMessageKey.plugin_parent_not_supported, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getPluginParentRef()), new Object[]{this.pluginType.getFriendlyName()}));
                }
            }
        } else if (this.apiInstance.getParentRef() != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_parent_not_supported, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getPluginParentRef()), new Object[]{this.pluginType.getFriendlyName()}));
        }
    }

    private boolean isApiInstanceAnAncestorOfItsParent(String apiInstanceId, List<String> ancestorIDs) {
        for (String ancestorID : ancestorIDs) {
            if (!apiInstanceId.equals(ancestorID)) continue;
            return true;
        }
        return false;
    }

    protected void validateConfiguration() {
        if (this.apiInstance.getConfiguration() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_config_required, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getConfiguration())));
        } else if (this.pluginDescriptor != null) {
            this.domainConfiguration = this.validateAndTranslateConfig();
        }
    }

    private Configuration validateAndTranslateConfig() {
        Integer n;
        Integer n2;
        Integer i;
        boolean hasParent = this.parentId != null;
        boolean askedForParent = this.apiInstance.getParentRef() != null;
        boolean hasConfigErrors = false;
        GuiConfigDescriptor guiDescriptor = this.pluginDescriptor.getGuiConfigDescriptorBuilder().buildNewGuiDescriptor();
        PluginConfigTranslator translator = new PluginConfigTranslator();
        Configuration domainConfig = translator.apiToDomain(this.apiInstance.getConfiguration(), guiDescriptor, this.pluginType, askedForParent);
        this.appendErrors(translator.getValidationErrors());
        boolean bl = hasConfigErrors = !translator.getValidationErrors().isEmpty();
        if (translator.isTerminateValidation() || translator.hasInheritedConfig() && !hasParent) {
            return null;
        }
        List<ConfigField> apiFields = this.apiInstance.getConfiguration().getFields();
        List<ConfigTable> apiTables = this.apiInstance.getConfiguration().getTables();
        HashMap<String, Integer> fieldIndices = new HashMap<String, Integer>();
        HashMap<String, Integer> tableIndices = new HashMap<String, Integer>();
        if (apiFields != null) {
            i = 0;
            for (ConfigField apiField : apiFields) {
                fieldIndices.put(apiField.getName(), i);
                n2 = i;
                n = i = Integer.valueOf(i + 1);
            }
        }
        if (apiTables != null) {
            i = 0;
            for (ConfigTable apiTable : apiTables) {
                tableIndices.put(apiTable.getName(), i);
                n2 = i;
                n = i = Integer.valueOf(i + 1);
            }
        }
        Configuration validationConfig = domainConfig;
        if (hasParent) {
            ConfigurablePluginInstance domainInstance = this.pluginType.getPluginManager().newInstance();
            domainInstance.setId(this.apiInstance.getId());
            domainInstance.setName(this.apiInstance.getName());
            domainInstance.setDescriptor(this.pluginDescriptor);
            domainInstance.setParentId(this.parentId);
            domainInstance.setConfiguration(validationConfig);
            validationConfig = ConfigurationUtil.createAdminCompositeConfiguration((ConfigurablePluginInstance)domainInstance);
            validationConfig = ConfigurationUtil.sanitize((Configuration)validationConfig);
        }
        if (this.apiInstance instanceof AuthenticationSelector) {
            List<AuthenticationSelectorAttribute> extendedAttrs = ((AuthenticationSelector)this.apiInstance).getAttributeContract().getExtendedAttributes();
            if (this.pluginDescriptor.isSupportsExtendedContract() && CollectionUtils.isNotEmpty(extendedAttrs)) {
                for (AuthenticationSelectorAttribute extendedAttribute : extendedAttrs) {
                    if (validationConfig == null || extendedAttribute == null) continue;
                    validationConfig.getAdditionalAttrNames().add(extendedAttribute.getName());
                }
            }
        }
        domainConfig.setId(this.apiInstance.getId());
        PluginConfigValidator configValidator = new PluginConfigValidator(validationConfig, this.pluginDescriptor, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.getConfiguration()), fieldIndices, tableIndices, this.validatorContext);
        if (!configValidator.validate()) {
            this.appendErrors(configValidator.getErrors());
            boolean bl2 = hasConfigErrors = hasConfigErrors || !configValidator.getErrors().isEmpty();
        }
        if (hasConfigErrors) {
            return null;
        }
        return domainConfig;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public String getParentId() {
        return this.parentId;
    }

    public static PluginDescriptor getDescriptorByClassName(PluginManager<?, ?> pluginManager, String className) {
        Collection descriptors = pluginManager.getInstalledDescriptors();
        PluginDescriptor descriptor = null;
        for (PluginDescriptor aDesc : descriptors) {
            if (!aDesc.getPluginClassName().equals(className)) continue;
            descriptor = aDesc;
            break;
        }
        return descriptor;
    }

    public Configuration getDomainConfiguration() {
        return this.domainConfiguration;
    }

    public PluginManager<?, ?> getPluginManager() {
        return this.pluginManager;
    }

    protected boolean getBooleanVal(Boolean b) {
        if (b == null) {
            return false;
        }
        return b;
    }

    protected String getParentPath() {
        return "";
    }

    protected ValidatorContext getValidatorContext() {
        return this.validatorContext;
    }
}

