/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.validator.PluginTableRowValidator;
import com.pingidentity.admin.api.validator.PluginTableValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.TableDescriptor;

public class PluginTablesValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PluginTablesValidator.class);
    private final Configuration config;
    private final List<Table> tables;
    private final List<TableDescriptor> tableDescriptors;
    private final String fieldPath;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final Map<String, Integer> tableIndices;
    private ValidatorContext validatorContext;

    public PluginTablesValidator(List<Table> tables, List<TableDescriptor> tableDescriptors, Configuration config, String fieldPath) {
        this(tables, tableDescriptors, config, fieldPath, null, null);
    }

    public PluginTablesValidator(List<Table> tables, List<TableDescriptor> tableDescriptors, Configuration config, String fieldPath, Map<String, Integer> tableIndices, ValidatorContext validatorContext) {
        this.config = config;
        this.tables = tables;
        this.tableDescriptors = tableDescriptors;
        this.fieldPath = fieldPath;
        this.tableIndices = tableIndices;
        this.validatorContext = validatorContext;
    }

    public boolean validate() {
        HashMap<String, TableDescriptor> tableDescriptorsMap = new HashMap<String, TableDescriptor>();
        for (TableDescriptor desc : this.tableDescriptors) {
            tableDescriptorsMap.put(desc.getName(), desc);
        }
        int tableIndex = -1;
        for (Table table : this.tables) {
            String tablePath = this.getTablePath(table.getName(), ++tableIndex);
            Object tableNamePath = tablePath;
            if (this.tableIndices == null || this.tableIndices.containsKey(table.getName())) {
                tableNamePath = tablePath + "." + PluginInstancePaths.TablePaths.getName();
            }
            if (table.getName() == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_table_name_required, (String)tableNamePath));
                continue;
            }
            if (!tableDescriptorsMap.containsKey(table.getName())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_table_name_not_recognized, (String)tableNamePath, new Object[]{table.getName()}));
                continue;
            }
            TableDescriptor tableDescriptor = (TableDescriptor)tableDescriptorsMap.get(table.getName());
            this.validateTable(table, tablePath, tableDescriptor);
            int rowIndex = -1;
            int numDefaultRows = 0;
            for (Row row : table.getRows()) {
                if (row.isDefaultRow()) {
                    ++numDefaultRows;
                }
                String rowPath = tablePath + "." + PluginInstancePaths.TablePaths.getRow(++rowIndex);
                this.validateRow(row, rowPath, tableDescriptor);
            }
            if (!tableDescriptor.getRequireDefaultRow() || table.getRows() == null || table.getRows().size() <= 0) continue;
            if (numDefaultRows == 0) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_table_require_default_row, (String)tableNamePath, new Object[]{table.getName()}));
                continue;
            }
            if (numDefaultRows <= 1) continue;
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_table_require_only_one_default_row, (String)tableNamePath, new Object[]{table.getName()}));
        }
        return !this.hasErrors();
    }

    private String getTablePath(String tableName, int currentTableIndex) {
        if (this.tableIndices == null) {
            return this.fieldPath + "[" + currentTableIndex + "]";
        }
        Integer index = this.tableIndices.get(tableName);
        if (index == null) {
            return this.fieldPath;
        }
        return this.fieldPath + "[" + index + "]";
    }

    private void validateRow(Row row, String rowPath, TableDescriptor tableDescriptor) {
        PluginTableRowValidator validator = new PluginTableRowValidator((FieldList)row, rowPath, tableDescriptor, this.config, this.validatorContext);
        validator.validate();
        this.appendErrors(validator.getErrors());
    }

    private void validateTable(Table table, String tablePath, TableDescriptor tableDescriptor) {
        PluginTableValidator validator = new PluginTableValidator(table, tablePath, tableDescriptor);
        validator.validate();
        this.appendErrors(validator.getErrors());
    }
}

