/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ProtocolMessageCustomization;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashSet;
import java.util.List;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.metadata.Role;

public class ProtocolMessageCustomizationsValidator
extends AbstractValidator {
    private final List<ProtocolMessageCustomization> messageCustomizations;
    private final Protocol protocol;
    private final ConnectionType connType;
    private final WsFedTokenType tokenType;
    private String protocolString;
    private ValidatorContext validatorContext;

    public ProtocolMessageCustomizationsValidator(List<ProtocolMessageCustomization> messageCustomizations, ConnectionType type, Protocol protocol, ValidatorContext context) {
        this.messageCustomizations = messageCustomizations;
        this.connType = type;
        this.protocol = protocol;
        this.tokenType = null;
        this.protocolString = protocol == null ? "" : protocol.toString();
        this.validatorContext = context;
    }

    public ProtocolMessageCustomizationsValidator(List<ProtocolMessageCustomization> messageCustomizations, ConnectionType type, Protocol protocol, WsFedTokenType tokenType) {
        this.messageCustomizations = messageCustomizations;
        this.connType = type;
        this.protocol = protocol;
        this.tokenType = tokenType;
    }

    public boolean validate() {
        if (this.messageCustomizations == null || this.messageCustomizations.isEmpty()) {
            return true;
        }
        Role connRole = this.connType.getRole();
        if (!this.validatorContext.isAllowExpressionUpdates()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.expression_admin_role_required, ConnectionPaths.getMessageCustomizationsPropertyPath(connRole, this.protocol)));
            return false;
        }
        if (!ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocol_message_customization_expr_disabled, ConnectionPaths.getMessageCustomizationsPropertyPath(connRole, this.protocol)));
            return false;
        }
        HashSet<String> allowableContexts = new HashSet<String>();
        if (this.protocol == Protocol.SAML20 || this.protocol == Protocol.SAML10 || this.protocol == Protocol.SAML11 || this.protocol == null) {
            if (this.connType == ConnectionType.IDP) {
                allowableContexts.add("authn-request");
            } else {
                allowableContexts.add("assertion");
                allowableContexts.add("authn-response");
            }
        } else if (this.protocol == Protocol.WSFED && this.connType == ConnectionType.SP) {
            if (WsFedTokenType.JWT != this.tokenType) {
                allowableContexts.add("assertion");
            }
            allowableContexts.add("authn-response");
        }
        if (allowableContexts.isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocol_message_customization_not_supported, ConnectionPaths.getMessageCustomizationsPropertyPath(connRole, this.protocol), new Object[]{this.protocolString, this.connType.getLabel()}));
            return false;
        }
        HashSet<String> seenContextNames = new HashSet<String>();
        int i = 0;
        for (ProtocolMessageCustomization messageCustomization : this.messageCustomizations) {
            String contextName = messageCustomization.getContextName();
            String expr = messageCustomization.getMessageExpression();
            if (StringUtils.isBlank((String)contextName)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocol_message_customization_name_required, ConnectionPaths.getMessageCustomizationNamePropertyPath(connRole, i, this.protocol)));
            } else if (allowableContexts.contains(contextName)) {
                if (!seenContextNames.contains(contextName)) {
                    seenContextNames.add(contextName);
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocol_message_customization_duplicate_name, ConnectionPaths.getMessageCustomizationNamePropertyPath(connRole, i, this.protocol), new Object[]{contextName}));
                }
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocol_message_customization_name_invalid, ConnectionPaths.getMessageCustomizationNamePropertyPath(connRole, i, this.protocol), new Object[]{contextName, this.protocolString, this.connType.getLabel()}));
            }
            if (StringUtils.isBlank((String)expr)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocol_message_customization_expr_required, ConnectionPaths.getMessageCustomizationExprPropertyPath(connRole, i, this.protocol)));
            } else {
                try {
                    Ognl.parseExpression((String)expr);
                }
                catch (OgnlException e) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocol_message_customization_expr_invalid, ConnectionPaths.getMessageCustomizationExprPropertyPath(connRole, i, this.protocol)));
                }
            }
            ++i;
        }
        return !this.hasErrors();
    }
}

