/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.RedirectValidationLocalSettings;
import com.pingidentity.admin.api.model.RedirectValidationPartnerSettings;
import com.pingidentity.admin.api.model.RedirectValidationSettings;
import com.pingidentity.admin.api.model.RedirectValidationSettingsUriAllowlistEntry;
import com.pingidentity.admin.api.model.RedirectValidationSettingsWhitelistEntry;
import com.pingidentity.admin.api.model.fieldpaths.RedirectValidationSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;

public class RedirectValidationSettingsValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    protected TargetResourceValidationMgr targetResourceValidationMgr = (TargetResourceValidationMgr)GlobalRegistry.getService(TargetResourceValidationMgr.class);
    private RedirectValidationSettings settingsToValidate;

    public RedirectValidationSettingsValidator(RedirectValidationSettings settingsToValidate) {
        this.settingsToValidate = settingsToValidate;
    }

    private RedirectValidationLocalSettings getRedirectValidationLocalSettings() {
        return this.settingsToValidate.getRedirectValidationLocalSettings();
    }

    private RedirectValidationPartnerSettings getRedirectValidationPartnerSettings() {
        return this.settingsToValidate.getRedirectValidationPartnerSettings();
    }

    public boolean validate() {
        Object entry;
        int index;
        if (this.getRedirectValidationLocalSettings().getWhiteList() != null && !this.getRedirectValidationLocalSettings().getWhiteList().isEmpty()) {
            for (index = 0; index < this.getRedirectValidationLocalSettings().getWhiteList().size(); ++index) {
                entry = this.getRedirectValidationLocalSettings().getWhiteList().get(index);
                this.validateDomainInWhitelistEntry(index, (RedirectValidationSettingsWhitelistEntry)entry);
                List pathErrors = this.targetResourceValidationMgr.validatePath(((RedirectValidationSettingsWhitelistEntry)entry).getValidPath(), ((RedirectValidationSettingsWhitelistEntry)entry).isAllowQueryAndFragment());
                if (pathErrors.isEmpty()) continue;
                this.appendErrors(pathErrors, ApiMessageKey.whitelist_url_entry_invalid.getMsgKey(), RedirectValidationSettingsPaths.RedirectValidationLocalSettingsPaths.RedirectValidationSettingsWhitelistEntryPaths.getValidPathPath(index));
            }
        }
        if (this.getRedirectValidationLocalSettings().getUriAllowList() != null && !this.getRedirectValidationLocalSettings().getUriAllowList().isEmpty()) {
            for (index = 0; index < this.getRedirectValidationLocalSettings().getUriAllowList().size(); ++index) {
                entry = this.getRedirectValidationLocalSettings().getUriAllowList().get(index);
                List uriErrors = this.targetResourceValidationMgr.validateUri(((RedirectValidationSettingsUriAllowlistEntry)entry).getValidUri());
                this.appendErrors(uriErrors, ApiMessageKey.uri_allowlist_entry_invalid.getMsgKey(), RedirectValidationSettingsPaths.RedirectValidationLocalSettingsPaths.RedirectValidationSettingsUriAllowlistEntryPaths.getValidUriPath(index));
            }
        }
        return !this.hasErrors();
    }

    protected void validateDomainInWhitelistEntry(int index, RedirectValidationSettingsWhitelistEntry entry) {
        if (entry.getValidDomain() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, RedirectValidationSettingsPaths.RedirectValidationLocalSettingsPaths.RedirectValidationSettingsWhitelistEntryPaths.getValidDomainPath(index), new Object[]{"whitelist domain"}));
        } else {
            List domainErrors = this.targetResourceValidationMgr.validateDomain(entry.getValidDomain());
            if (!domainErrors.isEmpty()) {
                this.appendErrors(domainErrors, ApiMessageKey.whitelist_url_entry_invalid.getMsgKey(), RedirectValidationSettingsPaths.RedirectValidationLocalSettingsPaths.RedirectValidationSettingsWhitelistEntryPaths.getValidDomainPath(index));
            }
        }
    }

    protected void appendErrors(List<String> errors, String msgKey, String fieldPath) {
        for (String domainError : errors) {
            this.appendError(this.errorFactory.create(msgKey, domainError, fieldPath));
        }
    }
}

