/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.sso.idp.DataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.JdbcDataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.LdapDataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.SqlMethod;
import com.pingidentity.admin.api.model.sso.idp.StoredProcedure;
import com.pingidentity.admin.api.model.sso.idp.Table;
import com.pingidentity.admin.api.validator.AttributeFulfillmentValueValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class RepositoryAttributeFulfillmentValidator {
    private RepositoryAttributeFulfillmentValidator() {
    }

    public static Validator getInstance(DataStoreRepository dataStoreRepository, Set<SourceType> validSourceTypes, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, ValidatorContext context) {
        switch (dataStoreRepository.getType()) {
            case LDAP: {
                LdapDataStoreRepository ldapDataStoreRepository = (LdapDataStoreRepository)dataStoreRepository;
                return new LdapRepositoryAttributeFulfillmentValidator(ldapDataStoreRepository, validSourceTypes, validSources, context);
            }
            case JDBC: {
                JdbcDataStoreRepository jdbcDataStoreRepository = (JdbcDataStoreRepository)dataStoreRepository;
                return new JdbcRepositoryAttributeFulfillmentValidator(jdbcDataStoreRepository, validSourceTypes, validSources, context);
            }
        }
        return null;
    }

    private static class JdbcRepositoryAttributeFulfillmentValidator
    extends CompositeValidator {
        private final JdbcDataStoreRepository jdbcDataStoreRepository;
        private final Map<String, AttributeFulfillmentValue> attributeFulfillment;
        private final Set<SourceType> validSourceTypes;
        private final Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources;
        private final ValidatorContext context;
        private final DataSourceManager dsManager;

        public JdbcRepositoryAttributeFulfillmentValidator(JdbcDataStoreRepository jdbcDataStoreRepository, Set<SourceType> validSourceTypes, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, ValidatorContext context) {
            this.jdbcDataStoreRepository = jdbcDataStoreRepository;
            this.attributeFulfillment = jdbcDataStoreRepository.getJitRepositoryAttributeMapping();
            this.validSourceTypes = validSourceTypes;
            this.validSources = validSources;
            this.context = context;
            this.dsManager = MgmtFactory.getDataSourceManager();
        }

        @Override
        public boolean validate() {
            boolean isValid = super.validate();
            HashSet<String> validAttributes = new HashSet<String>();
            String fulfillmentPath = ConnectionPaths.getJitProvisioningAttributeMapping();
            String dataStoreId = this.jdbcDataStoreRepository.getDataStoreRef().getId();
            JdbcDataSource jdbcDs = this.dsManager.getJdbcDataSource(dataStoreId);
            SqlMethod sqlMethod = this.jdbcDataStoreRepository.getSqlMethod();
            if (jdbcDs != null) {
                if (sqlMethod != null) {
                    StoredProcedure storedProcedure;
                    List allColsWithMetadata;
                    if (sqlMethod.getTable() != null) {
                        Table table = sqlMethod.getTable();
                        if (table.getSchema() != null && table.getTableName() != null) {
                            allColsWithMetadata = jdbcDs.getUnsortedColumnsWithMetadata(table.getSchema(), table.getTableName());
                            for (ResultInfo resultInfo : allColsWithMetadata) {
                                validAttributes.add(resultInfo.getColumnName());
                            }
                        }
                    } else if (sqlMethod.getStoredProcedure() != null && (storedProcedure = sqlMethod.getStoredProcedure()).getSchema() != null && storedProcedure.getStoredProcedure() != null) {
                        allColsWithMetadata = jdbcDs.getUnsortedStoredProcedureColumnsWithMetadata(storedProcedure.getSchema(), storedProcedure.getStoredProcedure());
                        for (ResultInfo resultInfo : allColsWithMetadata) {
                            validAttributes.add(resultInfo.getColumnName());
                        }
                    }
                }
                for (String attrName : validAttributes) {
                    AttributeFulfillmentValue attrValue = this.attributeFulfillment.get(attrName);
                    AttributeFulfillmentValueValidator attributeFulfillmentValueValidator = new AttributeFulfillmentValueValidator(this.validSourceTypes, this.validSources, this.context, fulfillmentPath, attrName, attrValue);
                    attributeFulfillmentValueValidator.validate();
                    if (!attributeFulfillmentValueValidator.hasErrors()) continue;
                    this.appendErrors(attributeFulfillmentValueValidator.getErrors());
                    isValid = false;
                }
            }
            return isValid;
        }
    }

    private static class LdapRepositoryAttributeFulfillmentValidator
    extends CompositeValidator {
        private final Map<String, AttributeFulfillmentValue> attributeFulfillment;
        private final Set<SourceType> validSourceTypes;
        private final Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources;
        private final ValidatorContext context;

        public LdapRepositoryAttributeFulfillmentValidator(LdapDataStoreRepository ldapDataStoreRepository, Set<SourceType> validSourceTypes, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, ValidatorContext context) {
            this.attributeFulfillment = ldapDataStoreRepository.getJitRepositoryAttributeMapping();
            this.validSourceTypes = validSourceTypes;
            this.validSources = validSources;
            this.context = context;
        }

        @Override
        public boolean validate() {
            boolean isValid = super.validate();
            String fulfillmentPath = ConnectionPaths.getJitProvisioningAttributeMapping();
            for (Map.Entry<String, AttributeFulfillmentValue> entry : this.attributeFulfillment.entrySet()) {
                String attrName = entry.getKey();
                AttributeFulfillmentValue attrValue = entry.getValue();
                AttributeFulfillmentValueValidator attributeFulfillmentValueValidator = new AttributeFulfillmentValueValidator(this.validSourceTypes, this.validSources, this.context, fulfillmentPath, attrName, attrValue);
                attributeFulfillmentValueValidator.validate();
                if (!attributeFulfillmentValueValidator.hasErrors()) continue;
                this.appendErrors(attributeFulfillmentValueValidator.getErrors());
                isValid = false;
            }
            return isValid;
        }
    }
}

