/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.net.URI;
import java.net.URISyntaxException;

public class ResourceUriValidator
extends AbstractValidator {
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private String resourceUri;
    private ApiMessageEnum messageKey;
    private String fieldPath;

    public ResourceUriValidator(String resourceUri, ApiMessageEnum messageKey, String fieldPath) {
        this.resourceUri = resourceUri;
        this.messageKey = messageKey;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        boolean valid = true;
        try {
            URI uri = new URI(this.resourceUri);
            if (!uri.isAbsolute() || uri.getQuery() != null || uri.getFragment() != null) {
                valid = false;
            }
        }
        catch (URISyntaxException e) {
            valid = false;
        }
        if (!valid) {
            this.appendError(this.errorFactory.create(this.messageKey, this.fieldPath));
        }
        return !this.hasErrors();
    }
}

