/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SaasAttributeMapping;
import com.pingidentity.admin.api.model.SaasFieldConfiguration;
import com.pingidentity.admin.api.model.SaasFieldParsing;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.plugin.CharacterCase;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.OgnlExpressionValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.provisioner.mapping.FieldInfo;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SaasAttributeMappingValidator
extends CompositeValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private SaasAttributeMapping mapping;
    private int index;
    private FieldInfo fieldDesc;
    private Set<String> ldapNames;
    private int fieldIndex;
    private boolean isGroupAttribute;
    private ValidatorContext context;

    SaasAttributeMappingValidator(int index, SaasAttributeMapping mapping, FieldInfo fieldDesc, Set<String> ldapNames, int fieldIndex, ValidatorContext context) {
        this.mapping = mapping;
        this.index = index;
        this.fieldDesc = fieldDesc;
        this.ldapNames = ldapNames;
        this.fieldIndex = fieldIndex;
        this.context = context;
        this.addValidator((Validator)new NotNullValidator(mapping.getSaasFieldInfo(), ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMappingSaasFieldInfo(index, fieldIndex), ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMappingSaasFieldInfo(index, fieldIndex)));
    }

    SaasAttributeMappingValidator(int index, SaasAttributeMapping mapping, Set<String> ldapNames, int fieldIndex, ValidatorContext context) {
        this(index, mapping, null, ldapNames, fieldIndex, context);
        this.isGroupAttribute = true;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        SaasFieldConfiguration config = this.mapping.getSaasFieldInfo();
        if (this.isGroupAttribute) {
            if (config == null || config.getAttributeNames().size() > 1 || StringUtils.isNotEmpty((String)config.getExpression())) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_group_attribute_expression_value, ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMapping(this.index, this.fieldIndex), new Object[]{this.mapping.getFieldName()});
                this.appendError(error);
            } else {
                this.validateLdapAttributeName(this.fieldIndex, config);
            }
        } else if (this.fieldDesc.getCode().equals(this.mapping.getFieldName()) && config != null && config.getAttributeNames() != null) {
            this.validateLdapAttributeName(this.fieldIndex, config);
            if (this.fieldDesc.isLdapMap()) {
                if (StringUtils.isNotBlank((String)config.getDefaultValue()) || StringUtils.isNotBlank((String)config.getExpression()) || CharacterCase.NONE != config.getCharacterCase() || config.isCreateOnly() || config.isMasked() || config.isTrim() || SaasFieldParsing.NONE != config.getParser()) {
                    ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_LDAP_attribute_map_invalid, ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMapping(this.index, this.fieldIndex), new Object[]{this.fieldDesc.getCode()});
                    this.appendError(error);
                }
            } else if (config.getAttributeNames().size() > 1) {
                ExpressionManager expressionManager = ExpressionManager.getInstance();
                boolean expressionEnabled = expressionManager.isEvaluateExpressionsOn();
                if (expressionEnabled) {
                    if (StringUtils.isBlank((String)config.getExpression())) {
                        ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_expression_required, ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMapping(this.index, this.fieldIndex), new Object[]{this.fieldDesc.getCode()});
                        this.appendError(error);
                    } else if (StringUtils.isNotEmpty((String)config.getExpression())) {
                        this.validateExpression(config);
                    }
                } else {
                    ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_expression_disabled, ConnectionPaths.OutboundProvisionPaths.getChannelAttributeMapping(this.index, this.fieldIndex), new Object[]{this.fieldDesc.getCode()});
                    this.appendError(error);
                }
            } else if (StringUtils.isNotEmpty((String)config.getExpression())) {
                this.validateExpression(config);
            }
        }
        return !this.hasErrors();
    }

    private void validateExpression(SaasFieldConfiguration config) {
        HashMap<String, String> substitutionValues = new HashMap<String, String>();
        for (String substitutionVar : config.getAttributeNames()) {
            substitutionValues.put(substitutionVar, substitutionVar);
        }
        OgnlExpressionValidator ognlExpressionValidator = new OgnlExpressionValidator(config.getExpression(), ConnectionPaths.OutboundProvisionPaths.getChannelAttributeExpression(this.index, this.fieldIndex), true, substitutionValues, this.context);
        ognlExpressionValidator.validate();
        this.appendErrors(ognlExpressionValidator.getErrors());
    }

    private void validateLdapAttributeName(int fieldIndex, SaasFieldConfiguration config) {
        int configIndex = 0;
        for (String configName : config.getAttributeNames()) {
            if (!this.context.isBypassExternalValidation() && !this.ldapNames.contains(configName)) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.outbound_provisioning_invalid_LDAP_attribute, ConnectionPaths.OutboundProvisionPaths.getChannelMappedLdapAttributeName(this.index, fieldIndex, configIndex), new Object[]{configName});
                this.appendError(error);
            }
            ++configIndex;
        }
    }
}

