/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.plugin.ConfigField;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.validation.SaasParametersValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class SaasTargetValidator
extends AbstractValidator {
    protected transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private List<ConfigField> targetFields;
    private SaasProvisionerPlugin pluginDescInstance;
    private ValidatorContext context;

    SaasTargetValidator(SaasProvisionerPlugin pluginDescInstance, List<ConfigField> targetFields, ValidatorContext context) {
        this.pluginDescInstance = pluginDescInstance;
        this.targetFields = targetFields;
        this.context = context;
    }

    public boolean validate() {
        if (this.targetFields == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.OutboundProvisionPaths.getTargetSettings(), new Object[]{ConnectionPaths.OutboundProvisionPaths.getTargetSettings()}));
            return false;
        }
        for (Object fieldDescriptor : this.pluginDescInstance.getParameterDescriptors()) {
            List validationChain = fieldDescriptor.getValidationChain();
            if (validationChain == null) continue;
            for (Object fieldValidator : validationChain) {
                boolean isInput = false;
                for (ConfigField field : this.targetFields) {
                    String value;
                    if (!field.getName().equals(fieldDescriptor.getName())) continue;
                    if (field.getEncryptedValue() != null) {
                        value = field.getEncryptedValue();
                        EncryptedFieldValidator validator = new EncryptedFieldValidator(field.getValue(), value, ApiMessageKey.plugin_field_encrypted_value_invalid, ConnectionPaths.OutboundProvisionPaths.getTargetSettings(), field.getName());
                        if (!validator.validate()) {
                            this.appendErrors(validator.getErrors());
                        }
                    } else {
                        value = field.getValue();
                    }
                    isInput = true;
                    this.validateField((FieldDescriptor.FieldValidationWrapper)fieldValidator, new Field(field.getName(), fieldDescriptor.getLabel(), value));
                    break;
                }
                if (isInput) continue;
                this.validateField((FieldDescriptor.FieldValidationWrapper)fieldValidator, new Field(fieldDescriptor.getName(), fieldDescriptor.getLabel(), null));
            }
        }
        SimpleFieldList simpleFieldList = SaasTargetValidator.buildSimpleFieldList(this.targetFields);
        if (!this.hasErrors()) {
            for (SaasParametersValidator saasParametersValidator : this.pluginDescInstance.getSaasParametersValidators()) {
                try {
                    saasParametersValidator.validate(simpleFieldList);
                }
                catch (ValidationException e) {
                    for (String errorMsg : e.getErrorMessages()) {
                        this.appendError(new ValidationError(ApiMessageKey.plugin_validation_error.toString(), errorMsg, ConnectionPaths.OutboundProvisionPaths.getTargetSettings()));
                    }
                    break;
                }
                catch (Exception e) {
                    String message = "Unexpected exception thrown from plugin saas target validator" + (String)(e.getMessage() != null ? ": " + e.getMessage() : ".");
                    this.appendError(this.errorFactory.create(ApiMessageKey.plugin_validation_error, message, new Object[]{ConnectionPaths.OutboundProvisionPaths.getTargetSettings()}));
                    this.log.error((Object)message, (Throwable)e);
                    break;
                }
            }
        }
        SaasTarget saasTarget = new SaasTarget(this.pluginDescInstance.getId(), simpleFieldList);
        try {
            if (!(this.hasErrors() || this.context.isBypassExternalValidation() || saasTarget.testConnection())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.outbound_provisioning_target_connection_failed, ConnectionPaths.OutboundProvisionPaths.getTargetSettings()));
            }
        }
        catch (SaasException e) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.outbound_provisioning_target_connection_failed, ConnectionPaths.OutboundProvisionPaths.getTargetSettings()));
            this.log.error((Object)("Unable to connect to Outbound provisioning target. " + e.getMessage()));
        }
        return !this.hasErrors();
    }

    public static SimpleFieldList buildSimpleFieldList(List<ConfigField> parameters) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (parameters != null) {
            for (ConfigField fieldItem : parameters) {
                String value = StringUtils.isNotEmpty((String)fieldItem.getEncryptedValue()) ? EncryptedFieldValidator.decryptCiphertext(fieldItem.getEncryptedValue()) : fieldItem.getValue();
                Field field = new Field(fieldItem.getName(), value);
                fields.add(field);
            }
        }
        return new SimpleFieldList(fields);
    }

    private void validateField(FieldDescriptor.FieldValidationWrapper fieldValidator, Field field) {
        block3: {
            try {
                if (!StringUtils.isNotBlank((String)field.getValue()) && fieldValidator.isSkipIfValueIsEmpty()) break block3;
                fieldValidator.getValidator().validate(field);
            }
            catch (ValidationException e) {
                List fieldErrorMessages = e.getErrorMessages();
                for (String fieldErrorMessage : fieldErrorMessages) {
                    ValidationError error = this.errorFactory.create(ApiMessageKey.plugin_validation_error, fieldErrorMessage, new Object[]{ConnectionPaths.OutboundProvisionPaths.getTargetSettings()});
                    this.appendError(error);
                }
            }
        }
    }
}

