/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;

public class SecretReferenceValidator
extends AbstractValidator {
    private final String secretReference;
    private final String fieldPath;

    public SecretReferenceValidator(String secretReference, String fieldPath) {
        this.secretReference = secretReference;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        if (!SecretReferenceUtil.isSecretReference((String)this.secretReference)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.secret_manager_invalid_format, this.fieldPath));
        } else if (!SecretReferenceUtil.validateSecretManagerId((String)this.secretReference)) {
            String secretManagerId = SecretReferenceUtil.getSecretManagerId((String)this.secretReference);
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.secret_manager_invalid_id, this.fieldPath, new Object[]{secretManagerId == null ? "" : secretManagerId}));
        }
        return !this.hasErrors();
    }
}

