/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ServiceAuthentication;
import com.pingidentity.admin.api.model.fieldpaths.ServiceAuthenticationPaths;
import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class ServiceAuthenticationValidator
extends AbstractValidator {
    private ServiceAuthentication.ServiceModel attrQuery;
    private ServiceAuthentication.ServiceModel jmx;
    private ServiceAuthentication.ServiceModel connManagement;
    private ServiceAuthentication.ServiceModel ssoDirService;
    private String sharedSecret;
    private String encryptedSharedSecret;

    public ServiceAuthenticationValidator(ServiceAuthentication settings) {
        this.attrQuery = settings.getAttributeQuery();
        this.jmx = settings.getJmx();
        this.connManagement = settings.getConnectionManagement();
        this.ssoDirService = settings.getSsoDirectoryService();
    }

    public boolean validate() {
        this.validateAttributeQuery();
        this.validateJmx();
        this.validateConnectionManagement();
        this.validateSsoDirectoryService();
        return !this.hasErrors();
    }

    private void validateAttributeQuery() {
        if (this.attrQuery != null) {
            this.sharedSecret = this.attrQuery.getSharedSecret();
            this.encryptedSharedSecret = this.attrQuery.getEncryptedSharedSecret();
            if (StringUtils.isBlank((String)this.attrQuery.getId())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_service_id_required, ServiceAuthenticationPaths.getAttributeQueryId()));
            }
            if (StringUtils.isBlank((String)this.sharedSecret) && StringUtils.isBlank((String)this.encryptedSharedSecret)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_service_shared_secret_required, ServiceAuthenticationPaths.getAttributeQuerySharedSecret()));
            }
            this.validateSharedSecret(ServiceAuthenticationPaths.getAttributeQuerySharedSecret());
        }
    }

    private void validateJmx() {
        if (this.jmx != null) {
            this.sharedSecret = this.jmx.getSharedSecret();
            this.encryptedSharedSecret = this.jmx.getEncryptedSharedSecret();
            if (StringUtils.isBlank((String)this.jmx.getId())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_service_id_required, ServiceAuthenticationPaths.getJmxId()));
            }
            if (StringUtils.isBlank((String)this.sharedSecret) && StringUtils.isBlank((String)this.encryptedSharedSecret)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_service_shared_secret_required, ServiceAuthenticationPaths.getJmxSharedSecret()));
            }
            this.validateSharedSecret(ServiceAuthenticationPaths.getJmxSharedSecret());
        }
    }

    private void validateConnectionManagement() {
        if (this.connManagement != null) {
            this.sharedSecret = this.connManagement.getSharedSecret();
            this.encryptedSharedSecret = this.connManagement.getEncryptedSharedSecret();
            if (StringUtils.isBlank((String)this.connManagement.getId())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_service_id_required, ServiceAuthenticationPaths.getConnectionManagementId()));
            }
            if (StringUtils.isBlank((String)this.sharedSecret) && StringUtils.isBlank((String)this.encryptedSharedSecret)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_service_shared_secret_required, ServiceAuthenticationPaths.getConnectionManagementSharedSecret()));
            }
            this.validateSharedSecret(ServiceAuthenticationPaths.getConnectionManagementSharedSecret());
        }
    }

    private void validateSsoDirectoryService() {
        String id = "";
        this.sharedSecret = "";
        this.encryptedSharedSecret = "";
        if (this.ssoDirService != null) {
            id = this.ssoDirService.getId();
            this.sharedSecret = this.ssoDirService.getSharedSecret();
            this.encryptedSharedSecret = this.ssoDirService.getEncryptedSharedSecret();
        }
        if (StringUtils.isNotBlank((String)id) || StringUtils.isNotBlank((String)this.sharedSecret) || StringUtils.isNotBlank((String)this.encryptedSharedSecret)) {
            if (StringUtils.isBlank((String)id)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_service_id_required, ServiceAuthenticationPaths.getSsoDirectoryServiceId()));
            }
            if (StringUtils.isBlank((String)this.sharedSecret) && StringUtils.isBlank((String)this.encryptedSharedSecret)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_service_shared_secret_required, ServiceAuthenticationPaths.getSsoDirectoryServiceSharedSecret()));
            }
            this.validateSharedSecret(ServiceAuthenticationPaths.getSsoDirectoryServiceSharedSecret());
        }
    }

    private void validateSharedSecret(String fieldPath) {
        PasswordValidator passwordValidator;
        if (StringUtils.isNotBlank((String)this.sharedSecret) && !(passwordValidator = new PasswordValidator(this.sharedSecret, fieldPath, "sharedSecret")).validate()) {
            this.appendErrors(passwordValidator.getErrors());
        }
    }
}

