/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SloServiceEndpoint;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.PartnerUrlValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidatorFactory;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.sourceid.saml20.metadata.Role;

public class SloServiceEndpointValidator
extends AbstractValidator {
    private final List<SloServiceEndpoint> endpoints;
    private final boolean initSloEnabled;
    private final boolean isBaseUrlDefined;
    private final Role role;
    private final Protocol protocol;

    public SloServiceEndpointValidator(List<SloServiceEndpoint> endpoints, boolean initSloEnabled, boolean isBaseUrlDefined, Role role, Protocol protocol) {
        this.endpoints = endpoints;
        this.initSloEnabled = initSloEnabled;
        this.isBaseUrlDefined = isBaseUrlDefined;
        this.role = role;
        this.protocol = protocol;
    }

    public boolean validate() {
        ApiMessageKey errorMessage = ApiMessageKey.slo_service_endpoints_not_required;
        if (Protocol.OIDC == this.protocol) {
            errorMessage = ApiMessageKey.field_not_required;
        }
        if (Protocol.SAML20 != this.protocol) {
            if (this.endpoints != null && !this.endpoints.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(errorMessage, ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role), new Object[]{ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role)}));
                return false;
            }
            return true;
        }
        if (!this.initSloEnabled) {
            if (this.endpoints != null && !this.endpoints.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(errorMessage, ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role), new Object[]{ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role)}));
                return false;
            }
            return true;
        }
        if (this.endpoints == null || this.endpoints.isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.slo_service_endpoint_empty, ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role)));
            return false;
        }
        if (this.validateSloServiceEndpointListNullEntries()) {
            boolean bindingError = false;
            boolean missingUrlError = false;
            int i = 0;
            for (SloServiceEndpoint ssoEndpoint : this.endpoints) {
                if (ssoEndpoint.getBinding() == null && !bindingError) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.slo_service_endpoint_binding_missing, ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role)));
                    bindingError = true;
                }
                if (ssoEndpoint.getUrl() == null) {
                    if (!missingUrlError) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.slo_service_endpoint_url_missing, ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role)));
                        missingUrlError = true;
                    }
                } else {
                    String urlFieldPath = ConnectionPaths.getSloServiceEndpointsUrlPath(this.role, i);
                    this.validateUrl(ssoEndpoint.getUrl(), urlFieldPath);
                    if (ssoEndpoint.getResponseUrl() != null) {
                        String responseUrlFieldPath = ConnectionPaths.getSloServiceEndpointsResponseUrlPath(this.role, i);
                        this.validateUrl(ssoEndpoint.getResponseUrl(), responseUrlFieldPath);
                    }
                }
                ++i;
            }
        }
        return !this.hasErrors();
    }

    private boolean validateSloServiceEndpointListNullEntries() {
        int i = 0;
        for (SloServiceEndpoint endpoint : this.endpoints) {
            if (endpoint == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role, i)));
            }
            ++i;
        }
        return !this.hasErrors();
    }

    private void validateUrl(String url, String fieldPath) {
        PartnerUrlValidator urlValidator = PartnerUrlValidatorFactory.getBrowserSloEndpointUrlValidator(url, this.isBaseUrlDefined, fieldPath);
        urlValidator.validate();
        this.getErrors().addAll(urlValidator.getErrors());
    }
}

