/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.SmsProviderSettingsPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import org.apache.commons.lang.StringUtils;

public class SmsProviderSettingsValidator
extends CompositeValidator {
    private String smsAccountId;
    private String smsAuthToken;
    private String smsFromNumber;

    private SmsProviderSettingsValidator(Builder builder) {
        this.smsAccountId = builder.smsAccountId;
        this.smsAuthToken = builder.smsAuthToken;
        this.smsFromNumber = builder.smsFromNumber;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (StringUtils.isBlank((String)this.smsAccountId)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sms_provider_settings_account_id_required, SmsProviderSettingsPaths.getSmsAccountId()));
        }
        if (StringUtils.isBlank((String)this.smsAuthToken)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sms_provider_settings_auth_token_required, SmsProviderSettingsPaths.getSmsAuthToken()));
        }
        if (StringUtils.isBlank((String)this.smsFromNumber)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sms_provider_settings_from_number_required, SmsProviderSettingsPaths.getSmsFromNumber()));
        }
        return !this.hasErrors();
    }

    public static class Builder {
        String smsAccountId;
        String smsAuthToken;
        String smsFromNumber;

        public Builder setSmsAccountId(String smsAccountId) {
            this.smsAccountId = smsAccountId;
            return this;
        }

        public Builder setSmsAuthToken(String smsAuthToken) {
            this.smsAuthToken = smsAuthToken;
            return this;
        }

        public Builder setSmsFromNumber(String smsFromNumber) {
            this.smsFromNumber = smsFromNumber;
            return this;
        }

        public SmsProviderSettingsValidator build() {
            return new SmsProviderSettingsValidator(this);
        }
    }
}

