/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SpAdapterUrlMapping;
import com.pingidentity.admin.api.model.SpAdapterUrlMappings;
import com.pingidentity.admin.api.model.fieldpaths.SpAdapterUrlMappingPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.saml20.profiles.sp.UrlMatchingService;
import org.sourceid.saml20.profiles.sp.UrlMatchingServiceOneStarImpl;

public class SpAdapterUrlMappingValidator
extends CompositeValidator {
    private final SpAdapterUrlMappings apiMappings;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final SpAdapterManager spAdapterManager = MgmtFactory.getSpAdapterManager();
    private final UrlMatchingService urlMatcher = new UrlMatchingServiceOneStarImpl();

    public SpAdapterUrlMappingValidator(SpAdapterUrlMappings apiMappings) {
        this.apiMappings = apiMappings;
        for (SpAdapterUrlMapping apiMapping : apiMappings.getItems()) {
            this.addValidator((Validator)new ResourceIdValidator(apiMapping.getAdapterRef(), "adapterRef ID", SpAdapterUrlMappingPaths.getAdapterRef()));
            if (apiMapping.getAdapterRef() == null || !StringUtils.isNotBlank((String)apiMapping.getAdapterRef().getId())) continue;
            this.addValidator((Validator)new PluginExistsValidator((PluginManager<?, ?>)this.spAdapterManager, apiMapping.getAdapterRef().getId(), SpAdapterUrlMappingPaths.getAdapterRef(), ApiMessageKey.sp_adapter_not_found));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.apiMappings.getItems().isEmpty() && this.spAdapterManager.getInstances().size() > 1) {
            this.appendError(this.errorFactory.create(ApiMessageKey.sp_adapter_url_mapping_required, SpAdapterUrlMappingPaths.getAdapterRef()));
        }
        for (SpAdapterUrlMapping apiMapping : this.apiMappings.getItems()) {
            this.validateUrl(apiMapping.getUrl());
        }
        return !this.hasErrors();
    }

    private void validateUrl(String url) {
        if (StringUtils.isBlank((String)url)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.url_required, SpAdapterUrlMappingPaths.getUrl(), new Object[]{url}));
        } else if (!this.urlMatcher.isValidUrlPattern(url)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.malformed_url, SpAdapterUrlMappingPaths.getUrl(), new Object[]{url}));
        }
    }
}

