/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.model.plugin.SpAdapter;
import com.pingidentity.admin.api.model.plugin.SpAdapterAttribute;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AdapterValidator;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SpAdapterValidator
extends AdapterValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final SpAdapter apiAdapter;

    public SpAdapterValidator(SpAdapter apiInstance, boolean isCreate, ValidatorContext validatorContext) {
        this(apiInstance, isCreate, false, "", validatorContext);
    }

    public SpAdapterValidator(SpAdapter apiInstance, boolean isCreate, boolean isOverride, String parentPath, ValidatorContext validatorContext) {
        super(apiInstance, PluginEnum.SP_ADAPTER.getPluginManager(), isCreate, PluginEnum.SP_ADAPTER, isOverride, parentPath, validatorContext);
        this.apiAdapter = apiInstance;
    }

    @Override
    public boolean validate() {
        HttpUrlValidator applicationIconUrlValidator;
        boolean doTargetApplicationInfoValidation;
        super.validate();
        boolean askedForParent = this.apiAdapter.getParentRef() != null;
        boolean isInherited = this.getBooleanVal(this.apiAdapter.getAttributeContract().isInherited());
        boolean isTargetApplicationInfoInherited = this.getBooleanVal(this.apiAdapter.getTargetApplicationInfo().getInherited());
        boolean doContractValidation = !isInherited || !askedForParent;
        boolean bl = doTargetApplicationInfoValidation = !isTargetApplicationInfoInherited || !askedForParent;
        if (isInherited && !askedForParent) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_attribute_contract_parent_not_defined, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getContractInherited())));
        }
        if (isTargetApplicationInfoInherited && !askedForParent) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_target_application_info_parent_not_defined, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.TargetApplicationInfo.getInherited())));
        }
        if (doContractValidation) {
            boolean pluginAllowsExtAttrs = true;
            LinkedList<SpAdapterAttribute> attributes = new LinkedList<SpAdapterAttribute>();
            String pluginTypeId = null;
            if (this.apiAdapter.getPluginDescriptorRef() != null) {
                pluginTypeId = this.apiAdapter.getPluginDescriptorRef().getId();
            }
            if (pluginTypeId != null) {
                for (PluginDescriptor pluginDescriptor : PluginEnum.SP_ADAPTER.getPluginManager().getInstalledDescriptors()) {
                    if (!pluginDescriptor.getPluginClassName().equals(pluginTypeId)) continue;
                    Set descriptorAttrs = pluginDescriptor.getAttributeContractSet();
                    if (descriptorAttrs != null) {
                        for (String coreAttrName : descriptorAttrs) {
                            SpAdapterAttribute adapterAttr = new SpAdapterAttribute();
                            adapterAttr.setName(coreAttrName);
                            attributes.add(adapterAttr);
                        }
                    }
                    pluginAllowsExtAttrs = pluginDescriptor.isSupportsExtendedContract();
                    break;
                }
            }
            List<Object> extendedAttrs = new LinkedList();
            if (!pluginAllowsExtAttrs && this.apiAdapter.getAttributeContract().getExtendedAttributes() != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_ext_attrs_not_supported, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getExtendedContractAttributes())));
            } else {
                extendedAttrs = this.apiAdapter.getAttributeContract().getExtendedAttributes();
            }
            AttributeContractValidator attributeContractValidator = new AttributeContractValidator(attributes, extendedAttrs, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getAttributeContract()));
            attributeContractValidator.validate();
            this.appendErrors(attributeContractValidator.getErrors());
        }
        if (doTargetApplicationInfoValidation && !(applicationIconUrlValidator = new HttpUrlValidator(this.apiAdapter.getTargetApplicationInfo().getApplicationIconUrl(), true, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.TargetApplicationInfo.getApplicationIconUrl()))).validate()) {
            this.appendErrors(applicationIconUrlValidator.getErrors());
        }
        return !this.hasErrors();
    }
}

