/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.SpAttributeQuery;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.HashMap;
import java.util.Set;
import org.sourceid.saml20.domain.SourceContextType;

public class SpAttributeQueryValidator
extends BaseAttributeDataSourceValidator {
    public SpAttributeQueryValidator(SpConnection connection, ValidatorContext context) {
        super(context);
        ValidationError error;
        SpAttributeQuery attributeQuery = connection.getAttributeQuery();
        if (attributeQuery == null) {
            return;
        }
        if (connection.getBrowserSso() != null && connection.getBrowserSso().getProtocol() != Protocol.SAML20) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_query_saml2, ConnectionPaths.getAttributeQuery()));
            return;
        }
        if (attributeQuery.getAttributes().isEmpty()) {
            String attributesPath = ConnectionPaths.getAttributeQueryAttributes();
            error = ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, attributesPath, new Object[]{attributesPath});
            this.appendError(error);
        }
        if (attributeQuery.getAttributeSources().isEmpty()) {
            String attributeSourcesPath = ConnectionPaths.getAttributeQueryAttributeSources();
            error = ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, attributeSourcesPath, new Object[]{attributeSourcesPath});
            this.appendError(error);
        }
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        validSources.putAll(rootSources);
        this.mapDataStoreTypesToDsValidators(attributeQuery, validSources);
        AttributeMappingValidator validator = new AttributeMappingValidator((AttributeMapping)attributeQuery, this.getAllAttributeNames(attributeQuery), null, "", validSources, ConnectionPaths.getAttributeQuery(), true, this.getContext());
        this.addValidator((Validator)validator);
    }

    @Override
    public boolean validate() {
        if (this.hasErrors()) {
            return false;
        }
        return super.validate();
    }

    private ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForSpXasp());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private Set<String> getAllAttributeNames(SpAttributeQuery attributeQuery) {
        return attributeQuery.getAttributes();
    }
}

