/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AssertionLifetime;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.ArtifactValidator;
import com.pingidentity.admin.api.validator.AuthenticationPolicyContractAssertionMappingsValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.EnabledProfilesValidator;
import com.pingidentity.admin.api.validator.IdpAdapterMappingsValidator;
import com.pingidentity.admin.api.validator.IncomingBindingsValidator;
import com.pingidentity.admin.api.validator.ProtocolMessageCustomizationsValidator;
import com.pingidentity.admin.api.validator.SloServiceEndpointValidator;
import com.pingidentity.admin.api.validator.SpAttributeContractValidator;
import com.pingidentity.admin.api.validator.SpSsoServiceEndpointsValidator;
import com.pingidentity.admin.api.validator.UrlWhiteListValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.sp.UrlMatchingService;
import org.sourceid.saml20.profiles.sp.UrlMatchingServiceOneStarImpl;
import org.sourceid.websso.Protocol;

public class SpBrowserSsoValidator
extends CompositeValidator {
    private final SpConnection connection;
    private final Role role;
    private com.pingidentity.admin.api.model.Protocol protocol;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final UrlMatchingService urlMatcher = new UrlMatchingServiceOneStarImpl();

    public SpBrowserSsoValidator(SpConnection connection, ValidatorContext context) {
        boolean hasBrowserSso = connection.getSpBrowserSso() != null;
        this.connection = connection;
        this.role = connection.getType().getRole();
        if (hasBrowserSso) {
            SpBrowserSso browserSso = connection.getSpBrowserSso();
            this.protocol = browserSso.getProtocol();
            if (this.protocol == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.browser_sso_protocol_null, ConnectionPaths.getBrowserSsoProtocolPath(this.role)));
                return;
            }
            LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
            if (!localSettings.isEnableProtocolIdP(Protocol.valueOf((String)this.protocol.name()))) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.protocol_not_enabled, ConnectionPaths.getBrowserSsoProtocolPath(Role.SP)));
                return;
            }
            if (this.protocol != com.pingidentity.admin.api.model.Protocol.SAML20 && browserSso.getEnabledProfiles() != null && browserSso.getEnabledProfiles().size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getEnabledProfilesPropertyPath(this.role), new Object[]{ConnectionPaths.getEnabledProfilesPropertyPath(this.role)}));
            }
            if (this.protocol != com.pingidentity.admin.api.model.Protocol.SAML20 && browserSso.getIncomingBindings() != null && browserSso.getIncomingBindings().size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getIncomingBindingsPropertyPath(this.role), new Object[]{ConnectionPaths.getIncomingBindingsPropertyPath(this.role)}));
            }
            this.addValidator((Validator)new SpSsoServiceEndpointsValidator(connection));
            SloServiceEndpointValidator validator = new SloServiceEndpointValidator(connection.getSpBrowserSso().getSloServiceEndpoints(), connection.getSpBrowserSso().getEnabledProfiles() == null ? false : connection.getSpBrowserSso().getEnabledProfiles().contains((Object)Profile.SP_INITIATED_SLO) || connection.getSpBrowserSso().getEnabledProfiles().contains((Object)Profile.IDP_INITIATED_SLO), connection.getBaseUrl() != null, connection.getType().getRole(), this.protocol);
            this.addValidator((Validator)validator);
            if (this.protocol == com.pingidentity.admin.api.model.Protocol.SAML20) {
                this.addValidator((Validator)new EnabledProfilesValidator(connection));
                Set<Profile> enabledProfiles = connection.getSpBrowserSso().getEnabledProfiles();
                if (enabledProfiles != null && (enabledProfiles.contains((Object)Profile.SP_INITIATED_SSO) || enabledProfiles.contains((Object)Profile.SP_INITIATED_SLO) || enabledProfiles.contains((Object)Profile.IDP_INITIATED_SLO))) {
                    this.addValidator((Validator)new IncomingBindingsValidator(connection));
                }
            }
            this.addValidator((Validator)new ProtocolMessageCustomizationsValidator(browserSso.getMessageCustomizations(), connection.getType(), this.protocol, context));
            this.addValidator((Validator)new ArtifactValidator(connection, connection.getSpBrowserSso()));
            this.addValidator((Validator)new SpAttributeContractValidator(connection, browserSso.getAttributeContract().getCoreAttributes(), browserSso.getAttributeContract().getExtendedAttributes(), ConnectionPaths.getBrowserSsoAttrContractPath(Role.SP)));
            this.addValidator((Validator)new IdpAdapterMappingsValidator(connection.getSpBrowserSso(), connection.getVirtualEntityIds(), context));
            this.addValidator((Validator)new AuthenticationPolicyContractAssertionMappingsValidator(connection.getSpBrowserSso(), connection.getVirtualEntityIds(), MgmtFactory.getC2cContractManager(), context));
            if (this.protocol == com.pingidentity.admin.api.model.Protocol.WSFED) {
                this.addValidator((Validator)new UrlWhiteListValidator(browserSso.getUrlWhitelistEntries(), ConnectionType.SP));
            }
        }
    }

    @Override
    public boolean validate() {
        if (this.hasErrors()) {
            return false;
        }
        SpBrowserSso browserSso = this.connection.getSpBrowserSso();
        if (browserSso == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.browser_sso_required, ConnectionPaths.getBrowserSsoPropertyName(this.role)));
            return false;
        }
        int initialNumErrors = this.getErrors().size();
        if (this.protocol == com.pingidentity.admin.api.model.Protocol.SAML20 && browserSso.getSpSamlIdentityMapping() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getSpSamlIdentityMapping(), new Object[]{ConnectionPaths.getSpSamlIdentityMapping()}));
        }
        if (this.protocol == com.pingidentity.admin.api.model.Protocol.SAML20 && browserSso.getSpSamlIdentityMapping() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getSpSamlIdentityMapping(), new Object[]{ConnectionPaths.getSpSamlIdentityMapping()}));
        }
        if (this.protocol == com.pingidentity.admin.api.model.Protocol.WSFED) {
            if ((browserSso.getWsFedTokenType() == WsFedTokenType.SAML11 || browserSso.getWsFedTokenType() == WsFedTokenType.SAML20) && browserSso.getSpWsFedIdentityMapping() == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getSpWsFedIdentityMapping(), new Object[]{ConnectionPaths.getSpWsFedIdentityMapping()}));
            }
            if (this.connection.getType() == ConnectionType.SP && browserSso.getWsFedTokenType() == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getWsTrustTokenType(), new Object[]{ConnectionPaths.getWsTrustTokenType()}));
            }
            if (browserSso.getIncomingBindings() != null && browserSso.getIncomingBindings().size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getIncomingBindingsPropertyPath(this.role), new Object[]{ConnectionPaths.getIncomingBindingsPropertyPath(this.role)}));
            }
            if (browserSso.getSloServiceEndpoints() != null && browserSso.getSloServiceEndpoints().size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role), new Object[]{ConnectionPaths.getSloServiceEndpointsPropertyPath(this.role)}));
            }
        }
        if ((this.protocol != com.pingidentity.admin.api.model.Protocol.WSFED || this.connection.getType() != ConnectionType.SP) && browserSso.getWsFedTokenType() != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.wsfed_type_not_required, ConnectionPaths.getWsTrustTokenType(), new Object[]{ConnectionPaths.getWsTrustTokenType()}));
        }
        if (this.protocol != com.pingidentity.admin.api.model.Protocol.WSFED && browserSso.getUrlWhitelistEntries() != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.whitelist_url_not_applicable, ConnectionPaths.getWsTrustTokenType(), new Object[]{ConnectionPaths.getWsTrustTokenType()}));
        }
        if (com.pingidentity.admin.api.model.Protocol.isSaml1x(this.protocol)) {
            if (StringUtils.isEmpty((String)browserSso.getDefaultTargetUrl())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getDefaultTargetUrlPath(this.role), new Object[]{ConnectionPaths.getDefaultTargetUrlPath(this.role)}));
            } else if (!this.urlMatcher.isValidUrlPattern(browserSso.getDefaultTargetUrl())) {
                this.appendError(this.errorFactory.create(ApiMessageKey.malformed_url, ConnectionPaths.getDefaultTargetUrlPath(this.role), new Object[]{ConnectionPaths.getDefaultTargetUrlPath(this.role)}));
            }
        }
        this.checkAssertionLifetime();
        super.validate();
        return initialNumErrors == this.getErrors().size();
    }

    private void checkAssertionLifetime() {
        AssertionLifetime assertionLifetime = this.connection.getSpBrowserSso().getAssertionLifetime();
        if (assertionLifetime != null) {
            this.checkIntegerSize(assertionLifetime.getMinutesBefore(), "minutesBefore", ConnectionPaths.getAssertionBeforeLifetimePropertyPath());
            this.checkIntegerSize(assertionLifetime.getMinutesAfter(), "minutesAfter", ConnectionPaths.getAssertionAfterLifetimePropertyPath());
        } else {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.assertion_lifetime_required, ConnectionPaths.getAssertionLifetimePropertyPath()));
        }
    }

    private void checkIntegerSize(int minutes, String property, String propertyPath) {
        if (minutes < 1 || minutes > 65535) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.assertion_lifetime_out_of_range, propertyPath, new Object[]{property}));
        }
    }
}

