/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AdditionalAllowedEntitiesConfigurationValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ConnectionBaseValidator;
import com.pingidentity.admin.api.validator.OutboundProvisionValidator;
import com.pingidentity.admin.api.validator.SpAttributeQueryValidator;
import com.pingidentity.admin.api.validator.SpBrowserSsoValidator;
import com.pingidentity.admin.api.validator.SpCredentialsValidator;
import com.pingidentity.admin.api.validator.SpWsTrustValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.metadata.Role;

public class SpConnectionValidator
extends CompositeValidator {
    public SpConnectionValidator(ConnectionBase existingConn, SpConnection connection, ValidatorRegistry validatorRegistry, boolean fullValidationPath, ValidatorContext context) {
        boolean isUpdate = context.isUpdateRequest();
        if (connection.getBrowserSso() == null && connection.getAttributeQuery() == null && connection.getWsTrust() == null && connection.getOutboundProvision() == null) {
            String browserSsoAttributeQueryPaths = ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ", " + ConnectionPaths.getAttributeQuery();
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.browser_sso_or_attribute_query_required, browserSsoAttributeQueryPaths));
            return;
        }
        ConnectionBaseValidator connectionBaseValidator = new ConnectionBaseValidator(isUpdate, existingConn, connection);
        connectionBaseValidator.checkSpConnectionIdDuplicate();
        this.addValidator((Validator)connectionBaseValidator);
        if (connection.getBrowserSso() != null) {
            this.addValidator((Validator)new SpBrowserSsoValidator(connection, context));
        }
        this.addValidator((Validator)new SpWsTrustValidator(connection, context));
        this.addValidator((Validator)new SpAttributeQueryValidator(connection, context));
        this.addValidator((Validator)new SpCredentialsValidator(isUpdate, existingConn, connection, validatorRegistry, fullValidationPath));
        this.addValidator((Validator)new AdditionalAllowedEntitiesConfigurationValidator(connection));
        this.addValidator((Validator)new OutboundProvisionValidator(connection.getOutboundProvision(), existingConn, context));
    }
}

