/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ConnectionSigningSettingsValidator;
import com.pingidentity.admin.api.validator.EncryptionSettingsValidator;
import com.pingidentity.admin.api.validator.InboundBackChannelValidator;
import com.pingidentity.admin.api.validator.OutboundBackChannelValidator;
import com.pingidentity.admin.api.validator.SpDecryptionKeyPairValidator;
import com.pingidentity.admin.api.validator.SpEncryptionValidator;
import com.pingidentity.admin.api.validator.VerificationCertValidator;
import com.pingidentity.admin.api.validator.VerificationSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import org.sourceid.saml20.domain.ConnectionBase;

public class SpCredentialsValidator
extends CompositeValidator {
    private final SpConnection spConnection;

    public SpCredentialsValidator(boolean isUpdate, ConnectionBase existingConn, SpConnection connection, ValidatorRegistry validatorRegistry, boolean fullValidationPath) {
        this.spConnection = connection;
        VerificationCertValidator certValidator = null;
        if (connection.getCredentials() != null) {
            certValidator = new VerificationCertValidator(isUpdate, existingConn, connection.getCredentials().getCerts(), fullValidationPath);
            validatorRegistry.register(VerificationCertValidator.class, (Validator)certValidator);
            this.addValidator((Validator)certValidator);
            this.addValidator((Validator)new OutboundBackChannelValidator(connection));
            this.addValidator((Validator)new InboundBackChannelValidator(connection, existingConn, isUpdate, validatorRegistry, fullValidationPath));
        }
        VerificationSettingsValidator verificationSettingsValidator = new VerificationSettingsValidator(connection, certValidator, fullValidationPath);
        validatorRegistry.register(VerificationSettingsValidator.class, (Validator)verificationSettingsValidator);
        this.addValidator((Validator)verificationSettingsValidator);
        SpEncryptionValidator spEncryptionValidator = new SpEncryptionValidator(connection, fullValidationPath);
        validatorRegistry.register(EncryptionSettingsValidator.class, (Validator)spEncryptionValidator);
        this.addValidator((Validator)spEncryptionValidator);
        this.addValidator((Validator)new ConnectionSigningSettingsValidator(connection, fullValidationPath));
        SpDecryptionKeyPairValidator spDecryptionKeyPairValidator = new SpDecryptionKeyPairValidator(connection, fullValidationPath);
        this.addValidator((Validator)spDecryptionKeyPairValidator);
    }

    @Override
    public boolean validate() {
        if (this.spConnection.getCredentials() == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.credentials_required, ConnectionPaths.getCredentials()));
            return false;
        }
        return super.validate();
    }
}

