/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.SpDefaultUrlsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.LocalSettings;

public class SpDefaultUrlsValidator
extends AbstractValidator {
    private String ssoSuccessUrl;
    private String sloSuccessUrl;

    public SpDefaultUrlsValidator(Builder builder) {
        this.ssoSuccessUrl = builder.ssoSuccessUrl;
        this.sloSuccessUrl = builder.sloSuccessUrl;
    }

    public boolean validate() {
        if (!StringUtils.isBlank((String)this.ssoSuccessUrl) && !ValidationUtil.isValidHttpOrHttpsUrl((String)this.ssoSuccessUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sp_default_urls_invalid_successful_sso_url, SpDefaultUrlsPaths.getSsoSuccessUrl()));
        }
        if (!StringUtils.isBlank((String)this.sloSuccessUrl) && !ValidationUtil.isValidHttpOrHttpsUrl((String)this.sloSuccessUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sp_default_urls_invalid_successful_slo_url, SpDefaultUrlsPaths.getSloSuccessUrl()));
        }
        return !this.hasErrors();
    }

    private boolean isEnableSaml20SpOrWsFedSp(LocalSettings localSettings) {
        return localSettings.isEnableSamlSp() || localSettings.isEnableWsFedSp();
    }

    public static class Builder {
        private String ssoSuccessUrl;
        private String sloSuccessUrl;

        public Builder setSloSuccessUrl(String sloSuccessUrl) {
            this.sloSuccessUrl = sloSuccessUrl;
            return this;
        }

        public Builder setSsoSuccessUrl(String ssoSuccessUrl) {
            this.ssoSuccessUrl = ssoSuccessUrl;
            return this;
        }

        public SpDefaultUrlsValidator build() {
            return new SpDefaultUrlsValidator(this);
        }
    }
}

