/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.EncryptionPolicy;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.SpBrowserSsoAttributeContract;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpWsTrust;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.EncryptionSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.protocol.AssertionMapKeys;

public class SpEncryptionValidator
extends EncryptionSettingsValidator {
    private final EncryptionPolicy policy;
    private final List<String> contractAttributes;
    private final SpConnection connection;
    private boolean attributeQueryEncryption;

    public SpEncryptionValidator(SpConnection connection, boolean fullValidationPath) {
        super(connection.getCredentials(), fullValidationPath);
        this.connection = connection;
        if (connection.getSpBrowserSso() != null) {
            this.policy = connection.getSpBrowserSso().getEncryptionPolicy();
            this.contractAttributes = this.getAttrNamesFromContract(connection.getSpBrowserSso().getAttributeContract());
        } else {
            this.policy = null;
            this.contractAttributes = null;
        }
        if (connection.getAttributeQuery() != null) {
            this.attributeQueryEncryption = connection.getAttributeQuery().getPolicy().isEncryptAssertion();
        }
    }

    @Override
    public boolean validate() {
        if (this.isBrowserSsoExists() || this.isWsFedSaml2()) {
            String path;
            if (this.policy == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_policy_required, ConnectionPaths.getEncryptionPolicyPath(Role.SP)));
                return false;
            }
            if (this.policy.isEncryptAssertion()) {
                if (this.isWsFedSaml2()) {
                    path = ConnectionPaths.getEncryptionPolicyPath(Role.SP);
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_encrypt_assertion_unsupported, path, new Object[]{this.connection.getSpBrowserSso().getProtocol(), this.connection.getSpBrowserSso().getWsFedTokenType()}));
                } else if (!this.policy.getEncryptedAttributes().isEmpty()) {
                    String path2 = ConnectionPaths.getEncryptionPolicyPath(Role.SP);
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_encryptassertion_enryptattributes, path2));
                    return false;
                }
            }
            if (!this.policy.isEncryptAssertion() && this.policy.getEncryptedAttributes().isEmpty() || !this.policy.getEncryptedAttributes().isEmpty() && !this.doesListContainSamlSubject(this.policy.getEncryptedAttributes()) || this.isWsFedSaml2()) {
                if (this.policy.isEncryptSloSubjectNameId()) {
                    path = ConnectionPaths.getEncryptionPolicyEncryptSubjectPath(this.connection.getType().getRole());
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
                }
                if (this.policy.isSloSubjectNameIDEncrypted()) {
                    path = ConnectionPaths.getEncryptionPolicyAcceptEncryptedSubjectPath(this.connection.getType().getRole());
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
                }
                if (this.hasErrors()) {
                    return false;
                }
            }
            if (this.isBrowserSsoEncryptionRequired() && !this.policy.getEncryptedAttributes().isEmpty()) {
                this.validateAttributes();
            }
            if (!this.policy.isEncryptAssertion() && !this.contractAttributes.contains(AssertionMapKeys.getNameIdValueKey()) && (this.policy.isEncryptSloSubjectNameId() || this.policy.isSloSubjectNameIDEncrypted())) {
                path = "";
                path = this.policy.isEncryptSloSubjectNameId() ? ConnectionPaths.getEncryptionPolicyEncryptSubjectPath(Role.SP) : ConnectionPaths.getEncryptionPolicyAcceptEncryptedSubjectPath(Role.SP);
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encryption_policy_name_id_not_selected, path));
            }
        }
        return super.validate();
    }

    private boolean isBrowserSsoEncryptionRequired() {
        if (this.isBrowserSsoExists() && this.policy != null) {
            return this.policy.isEncryptAssertion() || !this.policy.getEncryptedAttributes().isEmpty();
        }
        return false;
    }

    private boolean isBrowserSsoExists() {
        return this.connection.isBrowserSsoSaml2();
    }

    private boolean isAttributeQueryEncryptionRequired() {
        return this.attributeQueryEncryption;
    }

    @Override
    boolean isEncryptionRequired() {
        return this.isBrowserSsoEncryptionRequired() || this.isAttributeQueryEncryptionRequired() || this.isWsTrustConfigured() || this.isEncryptionRequiredForWsFed();
    }

    private boolean isWsTrustConfigured() {
        if (this.connection.getWsTrust() != null) {
            SpWsTrust wsTrust = this.connection.getWsTrust();
            return wsTrust.isEncryptSaml2Assertion() || wsTrust.isGenerateKey();
        }
        return false;
    }

    private boolean isWsFedSaml2() {
        if (this.connection.getBrowserSso() == null || this.connection.getSpBrowserSso() == null) {
            return false;
        }
        return Protocol.WSFED == this.connection.getBrowserSso().getProtocol() && WsFedTokenType.SAML20 == this.connection.getSpBrowserSso().getWsFedTokenType();
    }

    private boolean isEncryptionRequiredForWsFed() {
        if (this.isWsFedSaml2()) {
            return !this.policy.getEncryptedAttributes().isEmpty();
        }
        return false;
    }

    private void validateAttributes() {
        for (String attribute : this.policy.getEncryptedAttributes()) {
            if (this.contractAttributes.contains(attribute)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.encrypted_attribute_not_valid, ConnectionPaths.getEncryptedAttributesPath(Role.SP), new Object[]{attribute, StringUtils.join(this.contractAttributes, (String)", ")}));
        }
    }

    private List<String> getAttrNamesFromContract(SpBrowserSsoAttributeContract attributeContract) {
        ArrayList<String> attributes = new ArrayList<String>(attributeContract.getCoreAttributes().size() + attributeContract.getExtendedAttributes().size());
        for (SpBrowserSsoAttribute attribute : attributeContract.getExtendedAttributes()) {
            attributes.add(attribute.getName());
        }
        for (SpBrowserSsoAttribute attribute : attributeContract.getCoreAttributes()) {
            attributes.add(attribute.getName());
        }
        return attributes;
    }

    private boolean doesListContainSamlSubject(List<String> encryptAttributeList) {
        if (encryptAttributeList != null && !encryptAttributeList.isEmpty()) {
            String samlSubjectNameId = AssertionMapKeys.getNameIdValueKey();
            for (String attrName : encryptAttributeList) {
                if (!samlSubjectNameId.equals(attrName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isExistingRSA() {
        org.sourceid.saml20.domain.SpConnection spConn = MgmtFactory.getConnectionManager().getSpConnection(this.connection.getId());
        if (spConn != null) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(spConn.getEncryptionSettings().getEncryptionPolicy().getKeyTransportAlgorithm());
        }
        return false;
    }
}

