/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpSsoServiceEndpoint;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AbstractSsoServiceEndpointValidator;
import com.pingidentity.admin.api.validator.SsoUrlIndexValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.metadata.Role;

public class SpSsoServiceEndpointsValidator
extends AbstractSsoServiceEndpointValidator {
    private final SpConnection connection;
    private static final Set<Binding> supportedEndpointBindings = new HashSet<Binding>();

    public SpSsoServiceEndpointsValidator(SpConnection connection) {
        super(connection.getSpBrowserSso().getSsoServiceEndpoints(), connection.getSpBrowserSso().getEnabledProfiles() == null ? false : connection.getSpBrowserSso().getEnabledProfiles().contains((Object)Profile.SP_INITIATED_SSO), connection.getBaseUrl() != null, connection.getSpBrowserSso().getProtocol(), connection.getType().getRole());
        this.connection = connection;
    }

    @Override
    public boolean validate() {
        int initNumErrors = this.getErrors().size();
        super.validate();
        List<SpSsoServiceEndpoint> endpoints = this.connection.getSpBrowserSso().getSsoServiceEndpoints();
        if (endpoints != null) {
            if (this.connection.getSpBrowserSso().getProtocol() == Protocol.WSFED) {
                this.checkSpWsFedEndpoints(endpoints);
            } else {
                this.checkForInvalidBindings(endpoints);
                if (!Protocol.isSaml1x(this.protocol)) {
                    this.checkOnlyOneDefault(endpoints);
                    this.validateIndexes(endpoints);
                }
            }
        }
        return this.getErrors().size() == initNumErrors;
    }

    private void checkSpWsFedEndpoints(List<SpSsoServiceEndpoint> endpoints) {
        super.checkWsFedEndpoints(endpoints);
        for (int i = 0; i < endpoints.size(); ++i) {
            SpSsoServiceEndpoint endpoint = endpoints.get(i);
            if (endpoint.getIndex() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getSpSsoServiceEndpointsIndexPath(i), new Object[]{"index"}));
            }
            if (endpoint.getIsDefault() == null || !endpoint.getIsDefault().booleanValue()) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getSpSsoServiceEndpointsIndexPath(i), new Object[]{"isDefault"}));
        }
    }

    private void checkForInvalidBindings(List<SpSsoServiceEndpoint> endpoints) {
        for (int i = 0; i < endpoints.size(); ++i) {
            SpSsoServiceEndpoint endpoint = endpoints.get(i);
            if (supportedEndpointBindings.contains((Object)endpoint.getBinding())) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_invalid_binding, ConnectionPaths.getSsoServiceEndpointsBindingPath(Role.SP, i), new Object[]{endpoint.getBinding(), StringUtils.join(supportedEndpointBindings, (String)",")}));
        }
    }

    private void validateIndexes(List<SpSsoServiceEndpoint> endpoints) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < endpoints.size(); ++i) {
            SpSsoServiceEndpoint endpoint = endpoints.get(i);
            indexes.add(endpoint.getIndex());
        }
        SsoUrlIndexValidator indexValidator = new SsoUrlIndexValidator(indexes);
        indexValidator.validate();
        this.appendErrors(indexValidator.getErrors());
    }

    private void checkOnlyOneDefault(List<SpSsoServiceEndpoint> endpoints) {
        boolean foundDefault = false;
        for (SpSsoServiceEndpoint endpoint : endpoints) {
            if (!endpoint.getIsDefault().booleanValue()) continue;
            if (foundDefault) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_multiple_defaults, ConnectionPaths.getSsoServiceEndpointsPropertyPath(Role.SP)));
                return;
            }
            foundDefault = true;
        }
        if (!foundDefault) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.sso_service_endpoint_no_default, ConnectionPaths.getSsoServiceEndpointsPropertyPath(Role.SP)));
        }
    }

    @Override
    protected Set<Binding> getSupportedBindings() {
        return supportedEndpointBindings;
    }

    static {
        supportedEndpointBindings.add(Binding.ARTIFACT);
        supportedEndpointBindings.add(Binding.POST);
    }
}

