/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;

public class SpWsTrustProtocolSettingsValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private String connectionId;
    private List<String> partnerServiceIds;

    public SpWsTrustProtocolSettingsValidator(String connectionId, List<String> partnerServiceIds) {
        this.connectionId = connectionId;
        this.partnerServiceIds = partnerServiceIds;
    }

    public boolean validate() {
        if (this.partnerServiceIds == null || this.partnerServiceIds.isEmpty()) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.partner_service_id_required, ConnectionPaths.WsTrustPaths.getPartnerServiceId());
            this.appendError(error);
            return false;
        }
        MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
        HashSet<AppliesTo> convertedAppliesTo = new HashSet<AppliesTo>();
        int index = 0;
        for (String partnerServiceId : this.partnerServiceIds) {
            ValidationError error;
            if (StringUtils.isBlank((String)partnerServiceId)) {
                error = this.errorFactory.create(ApiMessageKey.field_blank, ConnectionPaths.WsTrustPaths.getPartnerServiceId(index), new Object[]{ConnectionPaths.WsTrustPaths.getPartnerServiceId(index)});
                this.appendError(error);
            } else if (!ValidationUtil.isValidUri((String)partnerServiceId)) {
                error = this.errorFactory.create(ApiMessageKey.partner_service_id_not_valid, ConnectionPaths.WsTrustPaths.getPartnerServiceId(index));
                this.appendError(error);
            } else if (!convertedAppliesTo.add(new AppliesTo(partnerServiceId))) {
                error = this.errorFactory.create(ApiMessageKey.partner_service_id_duplicate, ConnectionPaths.WsTrustPaths.getPartnerServiceId(index));
                this.appendError(error);
            }
            ++index;
        }
        Set inUseParterServiceIds = metadataDirectory.getAppliesToInUseForSpConnections(convertedAppliesTo, this.connectionId);
        index = 0;
        for (AppliesTo inUsePartnerServiceId : inUseParterServiceIds) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.partner_service_id_in_use, ConnectionPaths.WsTrustPaths.getPartnerServiceId(index++), new Object[]{inUsePartnerServiceId.toString()});
            this.appendError(error);
        }
        return !this.hasErrors();
    }
}

