/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.IdpWsTrust;
import com.pingidentity.admin.api.model.SpTokenGeneratorMapping;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdpWsTrustAttributeContractValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.SpWsTrustTokenMappingValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.WsTrustRestrictedVirtualServerIdsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.List;

public class SpWsTrustTokenGeneratorMappingsValidator
extends CompositeValidator {
    private IdpConnection connection;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private ValidatorContext context;

    SpWsTrustTokenGeneratorMappingsValidator(IdpConnection connection, ValidatorContext context) {
        this.context = context;
        this.connection = connection;
        IdpWsTrust wsTrust = connection.getWsTrust();
        List<SpTokenGeneratorMapping> mappings = wsTrust.getTokenGeneratorMappings();
        if (mappings == null || mappings.isEmpty()) {
            if (wsTrust.getGenerateLocalToken()) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.WsTrustPaths.getTokenGeneratorMappings(), new Object[]{"Token Generator Mappings"});
                this.appendError(error);
            }
        } else if (!wsTrust.getGenerateLocalToken()) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.token_generator_mappings_not_required, ConnectionPaths.WsTrustPaths.getTokenGeneratorMappings());
            this.appendError(error);
        } else {
            this.addAdditionalAttributeContractValidator(connection, wsTrust);
            UniqueEntriesValidator.UniqueKeyGetter<SpTokenGeneratorMapping> keyGetter = new UniqueEntriesValidator.UniqueKeyGetter<SpTokenGeneratorMapping>(){

                @Override
                public String getKey(SpTokenGeneratorMapping object) {
                    if (object.getSpTokenGeneratorRef() != null && object.getSpTokenGeneratorRef().getId() != null) {
                        return object.getSpTokenGeneratorRef().getId();
                    }
                    return null;
                }
            };
            this.addValidator((Validator)new UniqueEntriesValidator<SpTokenGeneratorMapping>(keyGetter, mappings, ConnectionPaths.WsTrustPaths.getTokenGeneratorMappings(), ApiMessageKey.sp_token_generator_mappings_duplicate_mappings));
        }
    }

    private void addAdditionalAttributeContractValidator(IdpConnection connection, IdpWsTrust wsTrust) {
        this.addValidator((Validator)new NotNullValidator(wsTrust.getAttributeContract(), "Attribute Contract", ConnectionPaths.WsTrustPaths.getAttributeContract()));
        if (connection.getWsTrust().getAttributeContract() != null) {
            this.addValidator((Validator)new IdpWsTrustAttributeContractValidator(wsTrust.getAttributeContract().getCoreAttributes(), wsTrust.getAttributeContract().getExtendedAttributes(), ConnectionPaths.WsTrustPaths.getAttributeContract()));
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        IdpWsTrust wsTrust = this.connection.getWsTrust();
        List<SpTokenGeneratorMapping> mappings = wsTrust.getTokenGeneratorMappings();
        int mappingIndex = 0;
        boolean hasDefault = false;
        for (SpTokenGeneratorMapping mapping : mappings) {
            if (mapping.isDefaultMapping()) {
                if (hasDefault) {
                    ValidationError error = this.errorFactory.create(ApiMessageKey.token_generator_mappings_multiple_defaults, ConnectionPaths.WsTrustPaths.getDefaultMappingForTokenGeneratorMappings(mappingIndex));
                    this.appendError(error);
                } else {
                    hasDefault = true;
                }
            }
            this.addValidator((Validator)new WsTrustRestrictedVirtualServerIdsValidator(this.connection.getVirtualEntityIds(), mapping.getRestrictedVirtualEntityIds(), mappingIndex));
            SpWsTrustTokenMappingValidator validator = new SpWsTrustTokenMappingValidator(mapping, mappingIndex, wsTrust, this.context);
            this.addValidator((Validator)validator);
            ++mappingIndex;
        }
        if (wsTrust.getGenerateLocalToken() && !hasDefault) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.token_generator_mappings_no_default, ConnectionPaths.WsTrustPaths.getDefaultMappingForTokenGeneratorMappings(0));
            this.appendError(error);
        }
        super.validate();
        return !this.hasErrors();
    }
}

