/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.IdpWsTrust;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.SpTokenGeneratorMapping;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OnlyOneAttributeSourceValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.wstrust.mgmt.TokenPluginInstance;

public class SpWsTrustTokenMappingValidator
extends BaseAttributeDataSourceValidator {
    private IdpWsTrust wsTrustSettings;
    private SpTokenGeneratorMapping mapping;
    private int index;

    public SpWsTrustTokenMappingValidator(SpTokenGeneratorMapping mapping, int index, IdpWsTrust wsTrustSettings, ValidatorContext context) {
        super(context);
        this.mapping = mapping;
        this.index = index;
        this.wsTrustSettings = wsTrustSettings;
    }

    @Override
    public boolean validate() {
        ResourceIdValidator resourceIdValidator = new ResourceIdValidator(this.mapping.getSpTokenGeneratorRef(), "SP Token Generator reference", ConnectionPaths.WsTrustPaths.getTokenGeneratorMappings(this.index));
        this.addValidator((Validator)resourceIdValidator);
        if (!super.validate()) {
            return false;
        }
        String id = this.mapping.getSpTokenGeneratorRef().getId();
        PluginExistsValidator pluginExistsValidator = new PluginExistsValidator((PluginManager<?, ?>)MgmtFactory.getTokenGeneratorManager(), id, ConnectionPaths.WsTrustPaths.getTokenGeneratorMappingRefId(this.index), ApiMessageKey.token_generator_not_found, true);
        this.addValidator((Validator)pluginExistsValidator);
        if (!super.validate()) {
            return false;
        }
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> sources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        sources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        sources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        sources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        AttributeSetSourceTypeValidatorBuilder tokenTypeBuilder = this.createTokenTypeBuilder();
        sources.put(new SourceTypeIdKey(SourceType.ASSERTION), tokenTypeBuilder);
        sources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            sources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        sources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE), this.createDsValBuilder(SourceType.LDAP_DATA_STORE, this.mapping));
        sources.put(new SourceTypeIdKey(SourceType.JDBC_DATA_STORE), this.createDsValBuilder(SourceType.JDBC_DATA_STORE, this.mapping));
        sources.put(new SourceTypeIdKey(SourceType.CUSTOM_DATA_STORE), this.createDsValBuilder(SourceType.CUSTOM_DATA_STORE, this.mapping));
        this.mapDataStoreTypesToDsValidators(this.mapping, sources);
        Set<String> contract = this.getContract(id);
        String fieldPath = ConnectionPaths.WsTrustPaths.getSpAttributeSourceId(this.index, 0);
        this.addValidator((Validator)new OnlyOneAttributeSourceValidator(this.mapping.getAttributeSources().size(), ApiMessageKey.token_generator_mapping_multiple_attribute_source, fieldPath));
        AttributeMappingValidator attributeMappingValidator = new AttributeMappingValidator(this.mapping, contract, tokenTypeBuilder.getExposedSubstitutionVariables(), null, sources, ConnectionPaths.WsTrustPaths.getTokenGeneratorMappings(), this.getContext());
        this.addValidator((Validator)attributeMappingValidator);
        super.validate();
        return !this.hasErrors();
    }

    private AttributeSetSourceTypeValidatorBuilder createTokenTypeBuilder() {
        HashSet<String> srcNames = new HashSet<String>();
        Set coreContractNames = this.wsTrustSettings.getAttributeContract().getCoreAttributes().stream().map(Attribute::getName).collect(Collectors.toSet());
        Set mutableContractNames = this.wsTrustSettings.getAttributeContract().getExtendedAttributes().stream().map(Attribute::getName).collect(Collectors.toSet());
        srcNames.addAll(coreContractNames);
        srcNames.addAll(mutableContractNames);
        return new AttributeSetSourceTypeValidatorBuilder(srcNames, SourceType.ASSERTION);
    }

    private Set<String> getContract(String instanceId) {
        TokenPluginInstance instance = (TokenPluginInstance)MgmtFactory.getTokenGeneratorManager().getInstance(instanceId);
        HashSet<String> srcNames = new HashSet<String>();
        if (instance != null) {
            srcNames.addAll(instance.getAttributeContract().getAllAttrNamesSorted());
        }
        return srcNames;
    }

    private ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForWsTrustTokenGen());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }
}

