/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpWsTrust;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdpWsTrustTokenMappingsValidator;
import com.pingidentity.admin.api.validator.ProtocolMessageCustomizationsValidator;
import com.pingidentity.admin.api.validator.SpWsTrustAttributeContractValidator;
import com.pingidentity.admin.api.validator.SpWsTrustProtocolSettingsValidator;
import com.pingidentity.admin.api.validator.SpWsTrustTokenLifetimeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public class SpWsTrustValidator
extends CompositeValidator {
    public static final String ABORT_PATH = "Abort Path";
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private SpConnection connection;
    private ValidatorContext context;

    public SpWsTrustValidator(SpConnection connection, ValidatorContext context) {
        this.connection = connection;
        this.context = context;
    }

    @Override
    public boolean validate() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        boolean enabled = false;
        enabled = ConnectionType.IDP == this.connection.getType() ? localSettings.isEnableWsTrustSp() : localSettings.isEnableWsTrustIdP();
        if (!enabled && this.connection.getWsTrust() != null) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.ws_trust_not_enabled, ConnectionPaths.getWsTrust());
            this.appendError(error);
            return false;
        }
        if (this.connection.getWsTrust() == null) {
            return true;
        }
        SpWsTrust wsTrustSettings = this.connection.getWsTrust();
        SpWsTrustAttributeContractValidator attributeContractValidator = new SpWsTrustAttributeContractValidator(wsTrustSettings, wsTrustSettings.getAttributeContract().getCoreAttributes(), wsTrustSettings.getAttributeContract().getExtendedAttributes(), ConnectionPaths.WsTrustPaths.getAttributeContract());
        this.addValidator((Validator)attributeContractValidator);
        SpWsTrustProtocolSettingsValidator protocolSettingsValidator = new SpWsTrustProtocolSettingsValidator(this.connection.getId(), wsTrustSettings.getPartnerServiceIds());
        this.addValidator((Validator)protocolSettingsValidator);
        SpWsTrustTokenLifetimeValidator tokenLifetimeValidator = new SpWsTrustTokenLifetimeValidator(String.valueOf(wsTrustSettings.getMinutesBefore()), String.valueOf(wsTrustSettings.getMinutesAfter()));
        this.addValidator((Validator)tokenLifetimeValidator);
        IdpWsTrustTokenMappingsValidator mappingsValidator = new IdpWsTrustTokenMappingsValidator(this.connection, this.context);
        this.addValidator((Validator)mappingsValidator);
        this.addValidator((Validator)new ProtocolMessageCustomizationsValidator(wsTrustSettings.getMessageCustomizations(), this.connection.getType(), null, this.context));
        if (wsTrustSettings.getRequestContractRef() != null) {
            String id = wsTrustSettings.getRequestContractRef().getId();
            String requestContractPath = ConnectionPaths.WsTrustPaths.getRequestContractRef();
            if (StringUtils.isBlank((String)id)) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.field_blank, requestContractPath, new Object[]{"Request Contract"});
                this.appendError(error);
            } else {
                WsTrustRequestContractManager requestContractManager = MgmtFactory.getWsTrustRequestContractManager();
                WsTrustRequestContract contract = requestContractManager.findById(id);
                if (contract == null) {
                    ValidationError error = this.errorFactory.create(ApiMessageKey.request_contract_not_found, requestContractPath, new Object[]{id});
                    this.appendError(error);
                }
                if (wsTrustSettings.isAbortIfNotFulfilledFromRequest() == null) {
                    String abortPath = ConnectionPaths.WsTrustPaths.getIsAbort();
                    ValidationError error = this.errorFactory.create(ApiMessageKey.field_required, abortPath, new Object[]{ABORT_PATH});
                    this.appendError(error);
                }
            }
        } else if (wsTrustSettings.isAbortIfNotFulfilledFromRequest() != null) {
            String abortPath = ConnectionPaths.WsTrustPaths.getIsAbort();
            ValidationError error = this.errorFactory.create(ApiMessageKey.field_not_required, abortPath, new Object[]{ABORT_PATH});
            this.appendError(error);
        }
        super.validate();
        return !this.hasErrors();
    }
}

