/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SslServerSettings;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.PkCert;
import java.util.HashSet;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SslServerPkCertManager;

public class SslServerSettingsValidator
extends CompositeValidator {
    private SslServerSettings settings;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

    public SslServerSettingsValidator(SslServerSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean validate() {
        if (this.settings.getActiveRuntimeServerCerts() != null && this.settings.getActiveAdminConsoleCerts() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.getActiveAdminConsoleCerts(), new Object[]{"Active Admin Console Certificates"}));
        }
        if (this.settings.getActiveRuntimeServerCerts() == null && this.settings.getActiveAdminConsoleCerts() != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.getActiveRuntimeServerCerts(), new Object[]{"Active Runtime Certificates"}));
        }
        this.validateActiveCerts(CertType.RUNTIME, this.settings.getActiveRuntimeServerCerts());
        this.validateActiveCerts(CertType.ADMIN_CONSOLE, this.settings.getActiveAdminConsoleCerts());
        if (this.hasErrors()) {
            return false;
        }
        this.validateDefaultCert(CertType.RUNTIME, this.settings.getRuntimeServerCertRef(), this.settings.getActiveRuntimeServerCerts());
        this.validateDefaultCert(CertType.ADMIN_CONSOLE, this.settings.getAdminConsoleCertRef(), this.settings.getActiveAdminConsoleCerts());
        return !this.hasErrors();
    }

    private void validateActiveCerts(CertType certType, List<ResourceLink> activeCerts) {
        if (activeCerts != null) {
            if (activeCerts.isEmpty()) {
                String path = certType.getActiveCertsPath();
                this.appendError(this.errorFactory.create(ApiMessageKey.ssl_server_certificate_active_at_least_one, path));
                return;
            }
            HashSet<ResourceLink> seen = new HashSet<ResourceLink>();
            int index = 0;
            for (ResourceLink activeCertLink : activeCerts) {
                String path;
                if (seen.contains(activeCertLink)) {
                    path = certType.getActiveCertsPathIndex(index);
                    this.appendError(this.errorFactory.create(ApiMessageKey.ssl_server_certificate_active_duplicate, path));
                } else if (activeCertLink.getId() == null) {
                    path = certType.getActiveCertsPathIndex(index);
                    this.appendError(this.errorFactory.create(ApiMessageKey.ssl_server_certificate_id_required, path));
                } else if (MgmtFactory.getSslServerPkCertManager().getPkCert(activeCertLink.getId()) == null) {
                    String msg = certType.getActiveCertErrorMsg(index);
                    this.appendError(this.errorFactory.create(ApiMessageKey.ssl_server_certificate_not_found, certType.getActiveCertsPathIndex(index), new Object[]{activeCertLink.getId()}));
                }
                seen.add(activeCertLink);
                ++index;
            }
        }
    }

    private void validateDefaultCert(CertType certType, ResourceLink sslCertForActivation, List<ResourceLink> activeCerts) {
        if (sslCertForActivation == null) {
            this.appendError(this.errorFactory.create(certType.getDefaultCertRequiredMsg(), certType.getDefaultCertPath()));
            return;
        }
        if (sslCertForActivation.getId() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.ssl_server_certificate_id_required, certType.getDefaultCertIdPath()));
            return;
        }
        PkCert pkCert = certType.getManager().getPkCert(sslCertForActivation.getId());
        if (pkCert == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.ssl_server_certificate_not_found, certType.getDefaultCertPath(), new Object[]{sslCertForActivation.getId()}));
            return;
        }
        if (activeCerts != null && !activeCerts.contains(sslCertForActivation)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.ssl_server_certificate_not_active, certType.getDefaultCertPath()));
        }
    }

    static enum CertType {
        RUNTIME{

            @Override
            public String getActiveCertsPathIndex(int index) {
                return ConnectionPaths.getActiveRuntimeServerCerts(index);
            }

            @Override
            public String getActiveCertsPath() {
                return ConnectionPaths.getActiveRuntimeServerCerts();
            }

            @Override
            public String getActiveCertErrorMsg(int index) {
                return ConnectionPaths.getActiveRuntimeServerCerts(index);
            }

            @Override
            public ApiMessageKey getDefaultCertRequiredMsg() {
                return ApiMessageKey.ssl_server_certificate_setting_for_runtime_servers_required;
            }

            @Override
            public String getDefaultCertPath() {
                return ConnectionPaths.getCertForRuntimeServers();
            }

            @Override
            public String getDefaultCertIdPath() {
                return ConnectionPaths.getCertForRuntimeServersId();
            }

            @Override
            public SslServerPkCertManager getManager() {
                return MgmtFactory.getSslServerPkCertManager();
            }
        }
        ,
        ADMIN_CONSOLE{

            @Override
            public String getActiveCertsPathIndex(int index) {
                return ConnectionPaths.getActiveAdminConsoleCerts(index);
            }

            @Override
            public String getActiveCertsPath() {
                return ConnectionPaths.getActiveAdminConsoleCerts();
            }

            @Override
            public String getActiveCertErrorMsg(int index) {
                return ConnectionPaths.getActiveAdminConsoleCerts(index);
            }

            @Override
            public ApiMessageKey getDefaultCertRequiredMsg() {
                return ApiMessageKey.ssl_server_certificate_setting_for_admin_console_required;
            }

            @Override
            public String getDefaultCertPath() {
                return ConnectionPaths.getCertForAdminConsole();
            }

            @Override
            public String getDefaultCertIdPath() {
                return ConnectionPaths.getCertForAdminConsoleId();
            }

            @Override
            public SslServerPkCertManager getManager() {
                return MgmtFactory.getAdminSslServerPkCertManager();
            }
        };


        public abstract String getActiveCertsPathIndex(int var1);

        public abstract String getActiveCertsPath();

        public abstract String getActiveCertErrorMsg(int var1);

        public abstract ApiMessageKey getDefaultCertRequiredMsg();

        public abstract String getDefaultCertPath();

        public abstract String getDefaultCertIdPath();

        public abstract SslServerPkCertManager getManager();
    }
}

