/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.StsRequestParametersContractPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public class StsRequestParametersContractValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final WsTrustRequestContractManager requestContractManager;
    private final String contractId;
    private final String contractName;
    private final List<String> parameters;
    private final boolean isUpdate;

    public StsRequestParametersContractValidator(String contractId, String contractName, List<String> parameters, WsTrustRequestContractManager requestContractManager, boolean isUpate) {
        this.contractId = contractId;
        this.contractName = contractName;
        this.parameters = parameters;
        this.requestContractManager = requestContractManager;
        this.isUpdate = isUpate;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.contractId)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_contract_id_required, StsRequestParametersContractPaths.getId()));
        } else if (!StringUtils.isAlphanumeric((String)this.contractId)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_contract_id_invalid, StsRequestParametersContractPaths.getId()));
        }
        if (StringUtils.isBlank((String)this.contractName)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_contract_name_required, StsRequestParametersContractPaths.getName()));
        }
        if (this.parameters == null || this.parameters.size() == 0) {
            this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_parameter_required, StsRequestParametersContractPaths.getParameters()));
        } else {
            HashSet<String> duplicateAttributes = new HashSet<String>();
            int index = 0;
            for (String param : this.parameters) {
                if (StringUtils.isBlank((String)param)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_parameter_name_required, StsRequestParametersContractPaths.getParameterAtIndex(index)));
                } else if (!StringUtils.isAlphanumeric((String)param)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_parameter_name_invalid, StsRequestParametersContractPaths.getParameterAtIndex(index)));
                }
                if (!duplicateAttributes.add(param)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_parameter_name_already_exists, StsRequestParametersContractPaths.getParameterAtIndex(index), new Object[]{param}));
                }
                ++index;
            }
        }
        if (this.hasErrors()) {
            return false;
        }
        if (!this.isUpdate) {
            Collection existingContracts;
            if (this.requestContractManager.findById(this.contractId) != null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_duplicate_contract_id, StsRequestParametersContractPaths.getId()));
            }
            if ((existingContracts = this.requestContractManager.findAll()).stream().anyMatch(contract -> this.contractName.equals(contract.getName()))) {
                this.appendError(this.errorFactory.create(ApiMessageKey.sts_request_param_contract_request_duplicate_contract_name, StsRequestParametersContractPaths.getName()));
            }
        }
        return !this.hasErrors();
    }
}

