/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.validator.NameFormatValidator;
import java.util.Collections;
import java.util.Map;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class SubjectNameFormatValidator
extends NameFormatValidator {
    public SubjectNameFormatValidator(String nameFormat, String contractFieldPath, int index, BaseBrowserSso browserSso) {
        super(nameFormat, contractFieldPath, index);
        ConfigStore customNameFormatConfigStore = ConfigStoreFarm.getConfig((String)"custom-name-formats");
        Protocol protocol = browserSso.getProtocol();
        Map customSubjectNameFormats = Collections.EMPTY_MAP;
        if (protocol == Protocol.SAML20) {
            this.validFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName");
            this.validFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos");
            this.validFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            this.validFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            this.validFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml2-subject-name-formats", Collections.EMPTY_MAP);
        } else if (protocol == Protocol.SAML11) {
            this.validFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.0:assertion#emailAddress");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.0:assertion#X509SubjectName");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.0:assertion#WindowsDomainQualifiedName");
            customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml11-subject-name-formats", Collections.EMPTY_MAP);
        } else if (protocol == Protocol.SAML10) {
            this.validFormats.add("urn:oasis:names:tc:SAML:1.0:assertion#emailAddress");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.0:assertion#X509SubjectName");
            this.validFormats.add("urn:oasis:names:tc:SAML:1.0:assertion#WindowsDomainQualifiedName");
            customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml10-subject-name-formats", Collections.EMPTY_MAP);
        }
        if (protocol == Protocol.SAML20) {
            customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml2-subject-name-formats", Collections.EMPTY_MAP);
        } else if (protocol == Protocol.SAML11) {
            customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml11-subject-name-formats", Collections.EMPTY_MAP);
        } else if (protocol == Protocol.SAML10) {
            customSubjectNameFormats = customNameFormatConfigStore.getMapValue("saml10-subject-name-formats", Collections.EMPTY_MAP);
        }
        for (Object key : customSubjectNameFormats.keySet()) {
            this.validFormats.add((String)customSubjectNameFormats.get(key));
        }
    }
}

