/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpIdentityMapping;
import com.pingidentity.admin.api.validator.AccountLinkSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.IdpBrowserSsoValidator;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collections;
import java.util.List;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.websso.Protocol;

public class TargetSessionMappingsValidator
extends BaseAttributeDataSourceValidator {
    protected final IdpBrowserSso browserSso;
    protected final List<String> availableVirtualServerIds;

    public TargetSessionMappingsValidator(IdpBrowserSso browserSso) {
        this(browserSso, Collections.emptyList(), null);
    }

    public TargetSessionMappingsValidator(IdpBrowserSso browserSso, List<String> availableVirtualServerIds, ValidatorContext context) {
        super(context);
        this.browserSso = browserSso;
        this.availableVirtualServerIds = availableVirtualServerIds;
    }

    protected AccountLinkSourceTypeValidatorBuilder createAccountLinkValBuilder(IdpBrowserSso browserSso) {
        AccountLinkSourceTypeValidatorBuilder accountLinkValBuilder = new AccountLinkSourceTypeValidatorBuilder();
        accountLinkValBuilder.setLinkingEnabled(browserSso.getIdpIdentityMapping() == IdpIdentityMapping.ACCOUNT_LINKING);
        return accountLinkValBuilder;
    }

    protected AttributeSetSourceTypeValidatorBuilder createAssertionValBuilder(IdpBrowserSso browserSso) {
        return IdpBrowserSsoValidator.createAssertionValBuilder(browserSso);
    }

    protected ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        if (this.browserSso.getProtocol() != null) {
            builder.setContextSources(SourceContextType.getProtocolDependentContextTypesForIdpBrowserSSO((Protocol)Protocol.valueOf((String)this.browserSso.getProtocol().name())));
        } else {
            builder.setContextSources(SourceContextType.getContextTypesForIdpBrowserSSO());
        }
        return builder;
    }

    protected TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }
}

