/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.TokenToTokenMapping;
import com.pingidentity.admin.api.model.fieldpaths.GenericMappingsPaths;
import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.admin.api.validator.TokenToTokenAttributeMappingValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.sourceid.a2a.domain.mgmt.Token2TokenManager;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class TokenToTokenMappingValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final TokenToTokenMapping mappingToValidate;
    private final boolean isUpdate;
    private Token2TokenManager token2TokenMgr;
    private TokenProcessorManager tokenProcessorMgr;
    private TokenGeneratorManager tokenGeneratorMgr;
    private ValidatorContext context;

    public TokenToTokenMappingValidator(TokenToTokenMapping mappingToValidate, Token2TokenManager token2TokenMgr, TokenProcessorManager tokenProcessorMgr, TokenGeneratorManager tokenGeneratorMgr, ValidatorContext context) {
        this.mappingToValidate = mappingToValidate;
        this.isUpdate = context.isUpdateRequest();
        this.token2TokenMgr = token2TokenMgr;
        this.tokenProcessorMgr = tokenProcessorMgr;
        this.tokenGeneratorMgr = tokenGeneratorMgr;
        this.context = context;
    }

    public boolean validate() {
        HttpUrlValidator httpValidator;
        ConfigurablePluginInstance tokenGenerator;
        this.checkForRequiredFields();
        if (this.hasErrors()) {
            return false;
        }
        ConfigurablePluginInstance tokenProcessor = this.tokenProcessorMgr.getInstance(this.mappingToValidate.getSourceId());
        if (tokenProcessor == null || !tokenProcessor.getId().equals(this.mappingToValidate.getSourceId())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.token_to_token_mappings_source_doesnt_exist, GenericMappingsPaths.getSourceId(), new Object[]{this.mappingToValidate.getSourceId()}));
        }
        if ((tokenGenerator = this.tokenGeneratorMgr.getInstance(this.mappingToValidate.getTargetId())) == null || !tokenGenerator.getId().equals(this.mappingToValidate.getTargetId())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.token_to_token_mappings_target_doesnt_exist, GenericMappingsPaths.getTargetId(), new Object[]{this.mappingToValidate.getTargetId()}));
        }
        if (this.hasErrors()) {
            return !this.hasErrors();
        }
        this.checkForDuplicateMapping();
        TokenToTokenAttributeMappingValidator attributeMappingValidator = new TokenToTokenAttributeMappingValidator(this.mappingToValidate, tokenProcessor.getAttributeContract(), tokenGenerator.getAttributeContract(), "", this.context);
        if (!attributeMappingValidator.validate()) {
            super.getErrors().addAll(attributeMappingValidator.getErrors());
        }
        if (!(httpValidator = new HttpUrlValidator(this.mappingToValidate.getDefaultTargetResource(), true, GenericMappingsPaths.getDefaultTargetResource())).validate()) {
            super.getErrors().addAll(httpValidator.getErrors());
        }
        return !this.hasErrors();
    }

    void checkForRequiredFields() {
        if (this.mappingToValidate.getSourceId() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, GenericMappingsPaths.getSourceId(), new Object[]{"Token Processor ID"}));
        }
        if (this.mappingToValidate.getTargetId() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, GenericMappingsPaths.getTargetId(), new Object[]{"Token Generator ID"}));
        }
    }

    void checkForDuplicateMapping() {
        if (!this.isUpdate && this.token2TokenMgr.getMapping(this.mappingToValidate.getSourceId(), this.mappingToValidate.getTargetId()) != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.token_to_token_mappings_duplicate_mappings, GenericMappingsPaths.getId(), new Object[]{this.mappingToValidate.getSourceId(), this.mappingToValidate.getTargetId()}));
        }
    }
}

