/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.LinkedList;
import java.util.List;

public abstract class UrlIndexValidator
extends AbstractValidator {
    private final List<Integer> indexes;
    private final List<Integer> indexesSeen = new LinkedList<Integer>();

    public UrlIndexValidator(List<Integer> indexes) {
        this.indexes = indexes;
    }

    public boolean validate() {
        this.validateIndexes();
        return !this.hasErrors();
    }

    private void validateIndexes() {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Integer index = this.indexes.get(i);
            if (!this.checkNull(index, i)) continue;
            this.checkForDuplicateIndex(index, i);
            this.checkIndexRange(index, i);
        }
    }

    private boolean checkNull(Integer index, int arrayLoc) {
        NotNullValidator validator = new NotNullValidator(index, "index", this.getUrlPathIndex(arrayLoc));
        if (!validator.validate()) {
            this.appendErrors(validator.getErrors());
            return false;
        }
        return true;
    }

    private void checkIndexRange(Integer index, int arrayLoc) {
        if (index < 0 || index > 65535) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.getOutOfRangeMsg(), this.getUrlPathIndex(arrayLoc)));
        }
    }

    private void checkForDuplicateIndex(Integer index, int arrayLoc) {
        if (this.indexesSeen.contains(index)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.getDuplicateIndexMsg(), this.getUrlPathIndex(arrayLoc), new Object[]{index}));
        }
        this.indexesSeen.add(index);
    }

    protected abstract ApiMessageEnum getOutOfRangeMsg();

    protected abstract ApiMessageEnum getDuplicateIndexMsg();

    protected abstract String getUrlPathIndex(int var1);
}

