/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.validator.AttributeFulfillmentValueValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Map;
import java.util.Set;

public class UserRepositoryAttributeFulfillmentValidator
extends CompositeValidator {
    private final Map<String, AttributeFulfillmentValue> attributeFulfillment;
    private final Set<SourceType> validSourceTypes;
    private final Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources;
    private final String attributeFulfillmentPath;
    private final ValidatorContext context;

    public UserRepositoryAttributeFulfillmentValidator(Map<String, AttributeFulfillmentValue> attributeFulfillment, Set<SourceType> validSourceTypes, Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, String attributeFulfillmentPath, ValidatorContext context) {
        this.attributeFulfillment = attributeFulfillment;
        this.validSourceTypes = validSourceTypes;
        this.validSources = validSources;
        this.attributeFulfillmentPath = attributeFulfillmentPath;
        this.context = context;
    }

    @Override
    public boolean validate() {
        boolean isValid = super.validate();
        for (Map.Entry<String, AttributeFulfillmentValue> entry : this.attributeFulfillment.entrySet()) {
            String attrName = entry.getKey();
            AttributeFulfillmentValue attrValue = entry.getValue();
            AttributeFulfillmentValueValidator attributeFulfillmentValueValidator = new AttributeFulfillmentValueValidator(this.validSourceTypes, this.validSources, this.context, this.attributeFulfillmentPath, attrName, attrValue);
            attributeFulfillmentValueValidator.validate();
            if (!attributeFulfillmentValueValidator.hasErrors()) continue;
            this.appendErrors(attributeFulfillmentValueValidator.getErrors());
            isValid = false;
        }
        return isValid;
    }
}

