/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class UsernamePasswordCredentialsValidator
extends AbstractValidator {
    protected final String username;
    protected final String password;
    protected final String encryptedPassword;
    protected final String usernamePath;
    protected final String passwordPath;
    protected final String encryptedPasswordPath;
    protected String decryptedPassword;

    public UsernamePasswordCredentialsValidator(String username, String password, String encryptedPassword, String usernamePath, String passwordPath, String encryptedPasswordPath) {
        this.username = username;
        this.password = password;
        this.encryptedPassword = encryptedPassword;
        this.usernamePath = usernamePath;
        this.passwordPath = passwordPath;
        this.encryptedPasswordPath = encryptedPasswordPath;
    }

    public boolean validate() {
        EncryptedFieldValidator encryptedPasswordValidator = new EncryptedFieldValidator(this.password, this.encryptedPassword, ApiMessageKey.usernamepassword_encrypted_password_invalid, this.encryptedPasswordPath, new Object[0]);
        if (!encryptedPasswordValidator.validate()) {
            this.appendErrors(encryptedPasswordValidator.getErrors());
        } else {
            this.decryptedPassword = encryptedPasswordValidator.getPlaintext();
        }
        String string = this.decryptedPassword = this.decryptedPassword != null ? this.decryptedPassword : this.password;
        if (StringUtils.isBlank((String)this.username) && StringUtils.isBlank((String)this.decryptedPassword)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.usernamepassword_user_name_required, this.usernamePath));
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.usernamepassword_password_required, this.passwordPath));
            return !this.hasErrors();
        }
        if (!StringUtils.isBlank((String)this.username) && StringUtils.isBlank((String)this.decryptedPassword)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.usernamepassword_password_required, this.passwordPath));
        }
        if (StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.decryptedPassword)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.usernamepassword_user_name_required, this.usernamePath));
        }
        return !this.hasErrors();
    }
}

