/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionCredentials;
import com.pingidentity.admin.api.model.IdpAttributeQueryPolicy;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.CredentialsPath;
import com.pingidentity.admin.api.validator.DnValidator;
import com.pingidentity.admin.api.validator.VerificationCertValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;

public class VerificationSettingsValidator
extends AbstractValidator {
    protected Connection connection;
    private boolean fullValidationPath;
    private final VerificationCertValidator certValidator;

    public VerificationSettingsValidator(Connection connection, VerificationCertValidator validator, boolean fullValidationPath) {
        this.connection = connection;
        this.certValidator = validator;
        this.fullValidationPath = fullValidationPath;
    }

    private boolean requireSpDigitalVerification() {
        SpConnection conn = (SpConnection)this.connection;
        SpBrowserSso browserSso = conn.getSpBrowserSso();
        ConnectionCredentials credentials = conn.getCredentials();
        boolean ssoSelected = false;
        boolean sloSelected = false;
        boolean incomingPost = false;
        boolean incomingRedirect = false;
        boolean authnReqSigned = false;
        boolean outboundArtifactDsig = false;
        boolean isRequireSignedAttributeQuery = false;
        if (browserSso != null) {
            ssoSelected = browserSso.isAnySsoSelected();
            sloSelected = browserSso.isAnySloSelected();
            boolean bl = authnReqSigned = browserSso.isRequireSignedAuthnRequests() == null ? false : browserSso.isRequireSignedAuthnRequests();
            if (browserSso.getIncomingBindings() != null) {
                incomingPost = browserSso.getIncomingBindings().contains((Object)Binding.POST);
                incomingRedirect = browserSso.getIncomingBindings().contains((Object)Binding.REDIRECT);
            }
        }
        if (credentials != null && credentials.getInboundBackChannelAuth() != null) {
            outboundArtifactDsig = credentials.getInboundBackChannelAuth().isDigitalSignature();
        }
        if (conn.getAttributeQuery() != null) {
            isRequireSignedAttributeQuery = conn.getAttributeQuery().getPolicy().isRequireSignedAttributeQuery();
        }
        return ssoSelected && (incomingPost || incomingRedirect) && sloSelected || authnReqSigned || outboundArtifactDsig || isRequireSignedAttributeQuery;
    }

    private boolean requireIdpDigitalVerification() {
        IdpConnection conn = (IdpConnection)this.connection;
        IdpBrowserSso browserSso = conn.getIdpBrowserSso();
        ConnectionCredentials credentials = conn.getCredentials();
        boolean ssoSelected = false;
        boolean incomingPost = false;
        boolean incomingRedirect = false;
        boolean assertionSigned = false;
        boolean wsfed = false;
        boolean xasp = false;
        boolean wstrust = false;
        boolean oauth = false;
        boolean outboundArtifactDsig = false;
        if (browserSso != null) {
            ssoSelected = browserSso.isAnySsoSelected();
            boolean bl = assertionSigned = browserSso.isAssertionsSigned() == null ? false : browserSso.isAssertionsSigned();
            if (browserSso.getIncomingBindings() != null) {
                incomingPost = browserSso.getIncomingBindings().contains((Object)Binding.POST);
                incomingRedirect = browserSso.getIncomingBindings().contains((Object)Binding.REDIRECT);
            }
            boolean bl2 = wsfed = browserSso.getProtocol() == Protocol.WSFED;
        }
        if (credentials != null && credentials.getInboundBackChannelAuth() != null) {
            outboundArtifactDsig = credentials.getInboundBackChannelAuth().isDigitalSignature();
        }
        if (conn.getAttributeQuery() != null) {
            IdpAttributeQueryPolicy policy = conn.getAttributeQuery().getPolicy();
            xasp = policy.isRequireSignedResponse() || policy.isRequireSignedAssertion();
        }
        return ssoSelected && (incomingPost || incomingRedirect || assertionSigned || wsfed) || xasp || wsfed || wstrust || oauth || outboundArtifactDsig;
    }

    protected boolean requireDigitalVerification() {
        if (this.connection.getType().getRole() == Role.SP) {
            return this.requireSpDigitalVerification();
        }
        return this.requireIdpDigitalVerification();
    }

    public boolean validate() {
        if (!this.requireDigitalVerification()) {
            return true;
        }
        if (StringUtils.isNotBlank((String)this.getSubjectDN())) {
            DnValidator dnv = new DnValidator(this.getSubjectDN(), this.getSubjectDNPath(), ApiMessageKey.anchored_trust_invalid_subject_dn);
            dnv.validate();
            this.appendErrors(dnv.getErrors());
            if (StringUtils.isNotBlank((String)this.getIssuerDN())) {
                dnv = new DnValidator(this.getIssuerDN(), this.getIssuerDNPath(), ApiMessageKey.anchored_trust_invalid_issuer_dn, true, ApiMessageKey.anchored_trust_not_a_trust_anchor, MgmtFactory.getTrustedCAsManager());
                dnv.validate();
                this.appendErrors(dnv.getErrors());
            }
        } else if (StringUtils.isNotBlank((String)this.getIssuerDN())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.anchored_trust_must_specify_subject_dn, this.getSubjectDNPath()));
        }
        if (StringUtils.isBlank((String)this.getSubjectDN()) && (this.getDomainCerts() == null || this.getDomainCerts().getActiveVerificationCert() == null)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.subject_dn_or_verification_cert_required, this.getCredentialsPath()));
        }
        return !this.hasErrors();
    }

    protected String getCredentialsPath() {
        return ConnectionPaths.getCredentials();
    }

    protected ConnectionCerts getDomainCerts() {
        if (this.certValidator != null) {
            return this.certValidator.getDomainCerts();
        }
        return null;
    }

    protected String getSubjectDN() {
        return this.connection.getCredentials().getVerificationSubjectDN();
    }

    protected String getSubjectDNPath() {
        return CredentialsPath.getVerificationSubjectDN(this.fullValidationPath);
    }

    protected String getIssuerDN() {
        return this.connection.getCredentials().getVerificationIssuerDN();
    }

    protected String getIssuerDNPath() {
        return CredentialsPath.getVerificationIssuerDN(this.fullValidationPath);
    }
}

