/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.UsernamePasswordCredentials;
import com.pingidentity.admin.api.model.WsTrustStsSettings;
import com.pingidentity.admin.api.model.fieldpaths.WsTrustStsSettingsPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.WsTrustClientCertAuthManager;

public class WsTrustStsSettingsValidator
extends CompositeValidator {
    private WsTrustStsSettings wsTrustStsSettings;
    private final WsTrustClientCertAuthManager clientCertAuthManager = MgmtFactory.getWsTrustClientCertAuthManager();

    public WsTrustStsSettingsValidator(WsTrustStsSettings wsTrustStsSettings) {
        this.wsTrustStsSettings = wsTrustStsSettings;
    }

    @Override
    public boolean validate() {
        this.validateClientCertAuthn();
        this.validateUsers();
        this.validateSubjectDns();
        this.validateIssuerCerts();
        return !this.hasErrors();
    }

    private void validateClientCertAuthn() {
        if (this.wsTrustStsSettings.isClientCertAuthnEnabled() && !this.wsTrustStsSettings.isRestrictByIssuerCert() && !this.wsTrustStsSettings.isRestrictBySubjectDn()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ws_trust_client_cert_need_restriction_method, WsTrustStsSettingsPaths.getClientCertAuthnEnabled()));
        }
    }

    private void validateUsers() {
        if (this.wsTrustStsSettings.isBasicAuthnEnabled() && this.wsTrustStsSettings.getUsers().size() < 1) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.http_basic_auth_need_users, WsTrustStsSettingsPaths.getUsers()));
        }
        HashSet<String> seenUsernames = new HashSet<String>();
        for (UsernamePasswordCredentials user : this.wsTrustStsSettings.getUsers()) {
            String username = user.getUsername();
            String password = user.getPassword();
            String encryptedPassword = user.getEncryptedPassword();
            if (StringUtils.isBlank((String)username)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.http_basic_auth_null_username, WsTrustStsSettingsPaths.getUsers()));
            }
            if (seenUsernames.contains(username)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.http_basic_auth_same_username, username));
            }
            if (password == null && encryptedPassword == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.http_basic_auth_no_password, username));
            } else if (password != null && encryptedPassword != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.http_basic_auth_both_passwords, username));
            } else if (password != null) {
                this.validatePassword(password);
            }
            seenUsernames.add(username);
        }
    }

    private void validatePassword(String password) {
        PasswordValidator passwordValidator = new PasswordValidator(password);
        if (!passwordValidator.validate()) {
            this.appendErrors(passwordValidator.getErrors());
        }
    }

    private void validateSubjectDns() {
        if (this.wsTrustStsSettings.isClientCertAuthnEnabled() && this.wsTrustStsSettings.isRestrictBySubjectDn() && this.wsTrustStsSettings.getSubjectDns().size() < 1) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ws_trust_client_cert_need_subject_dns, WsTrustStsSettingsPaths.getSubjectDns()));
        }
        for (String subjectDN : this.wsTrustStsSettings.getSubjectDns()) {
            if (ValidationUtil.isValidSubjectDN((String)subjectDN)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ws_trust_client_cert_auth_invalid_subject_dn, subjectDN));
        }
    }

    private void validateIssuerCerts() {
        Set existingAliases = this.clientCertAuthManager.getCerts().stream().map(Cert::getId).collect(Collectors.toSet());
        Set incomingAliases = this.wsTrustStsSettings.getIssuerCerts().stream().map(ResourceLink::getId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(incomingAliases)) {
            if (this.wsTrustStsSettings.isClientCertAuthnEnabled() && this.wsTrustStsSettings.isRestrictByIssuerCert()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ws_trust_client_cert_no_certs_defined, WsTrustStsSettingsPaths.getIssuerCerts()));
            }
        } else if (incomingAliases.contains(null)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ws_trust_client_cert_null_alias, WsTrustStsSettingsPaths.getIssuerCerts()));
        } else if (CollectionUtils.isEmpty(existingAliases)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ws_trust_client_cert_no_certs, WsTrustStsSettingsPaths.getIssuerCerts()));
        } else {
            Set difference = incomingAliases;
            difference.removeAll(existingAliases);
            if (!CollectionUtils.isEmpty(difference)) {
                for (String alias : difference) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ws_trust_client_cert_not_in_system, WsTrustStsSettingsPaths.getIssuerCerts(), new Object[]{alias}));
                }
            }
        }
    }
}

