/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.localidentity;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.fieldpaths.LocalIdentityProfilePaths;
import com.pingidentity.admin.api.model.localidentity.DataStoreAttribute;
import com.pingidentity.admin.api.model.localidentity.DataStoreConfig;
import com.pingidentity.admin.api.model.localidentity.LdapDataStoreConfig;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ExpectedAttributesValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class DataStoreAttributeValidator {
    private DataStoreAttributeValidator() {
    }

    public static Validator getInstance(DataStoreConfig dataStoreConfig) {
        switch (dataStoreConfig.getType()) {
            case LDAP: {
                LdapDataStoreConfig ldapDataStoreConfig = (LdapDataStoreConfig)dataStoreConfig;
                return new LdapDataStoreAttributeValidator(ldapDataStoreConfig);
            }
        }
        return null;
    }

    private static class LdapDataStoreAttributeValidator
    extends CompositeValidator {
        private final LdapDataStoreConfig ldapDataStoreConfig;

        private LdapDataStoreAttributeValidator(LdapDataStoreConfig ldapDataStoreConfig) {
            this.ldapDataStoreConfig = ldapDataStoreConfig;
            this.initialize();
        }

        private void initialize() {
            String dsId = this.ldapDataStoreConfig.getDataStoreRef().getId();
            LdapDataSource ldapStore = MgmtFactory.getDataSourceManager().getLdapDataSource(dsId);
            ArrayList<String> expectedAttributes = new ArrayList<String>();
            if (ldapStore != null) {
                expectedAttributes.add("Subject DN");
                expectedAttributes.addAll(ldapStore.getLDAPAttributeNameList());
            }
            int dsMappingKeyIndex = 0;
            Map<String, DataStoreAttribute> dataStoreMapping = this.ldapDataStoreConfig.getDataStoreMapping();
            if (dataStoreMapping == null || dataStoreMapping.isEmpty()) {
                this.addValidator((Validator)new NotNullValidator(dataStoreMapping, "Data Store Mapping", LocalIdentityProfilePaths.getDataStoreMapping()));
            } else {
                List dataStoreAttributeNames = dataStoreMapping.values().stream().filter(dataStoreAttribute -> dataStoreAttribute.getType().equals((Object)DataStoreType.LDAP)).map(DataStoreAttribute::getName).collect(Collectors.toList());
                for (String dataStoreAttributeName : dataStoreAttributeNames) {
                    this.addValidator((Validator)new ExpectedAttributesValidator(dataStoreAttributeName, expectedAttributes, ApiMessageKey.local_identity_profile_data_store_mapping_name_unknown_ldap_attribute_name, LocalIdentityProfilePaths.getDataStoreMapping(dsMappingKeyIndex++), "name"));
                }
            }
        }
    }
}

