/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.localidentity;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.LocalIdentityProfilePaths;
import com.pingidentity.admin.api.model.localidentity.DataStoreConfig;
import com.pingidentity.admin.api.model.localidentity.LdapDataStoreConfig;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.LdapNameValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.localidentity.DataStoreAttributeValidator;
import com.pingidentity.admin.api.validator.localidentity.LdapAuxiliaryObjectClassesValidator;
import com.pingidentity.admin.api.validator.localidentity.LdapCreatePatternValidator;
import com.pingidentity.admin.api.validator.localidentity.LdapObjectClassValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class DataStoreConfigValidator {
    private DataStoreConfigValidator() {
    }

    public static Validator getInstance(DataStoreConfig dataStoreConfig, Collection<String> availableVars, boolean isRegistrationEnabled, ValidatorContext context) {
        switch (dataStoreConfig.getType()) {
            case LDAP: {
                LdapDataStoreConfig ldapDataStoreConfig = (LdapDataStoreConfig)dataStoreConfig;
                return new LdapDataStoreConfigValidator(ldapDataStoreConfig, availableVars, isRegistrationEnabled, context);
            }
        }
        return null;
    }

    private static class LdapDataStoreConfigValidator
    extends CompositeValidator {
        private final LdapDataStoreConfig ldapDataStoreConfig;
        private final Collection<String> availableVars;
        private final boolean isRegistrationEnabled;
        private ValidatorContext context;

        private LdapDataStoreConfigValidator(LdapDataStoreConfig ldapDataStoreConfig, Collection<String> availableVars, boolean isRegistrationEnabled, ValidatorContext context) {
            this.ldapDataStoreConfig = ldapDataStoreConfig;
            this.availableVars = availableVars;
            this.isRegistrationEnabled = isRegistrationEnabled;
            this.context = context;
            this.addValidator((Validator)new ResourceIdValidator(ldapDataStoreConfig.getDataStoreRef(), "Data Store reference id", LocalIdentityProfilePaths.getDataStoreRef()));
            this.addValidator((Validator)new NotBlankValidator(ldapDataStoreConfig.getBaseDn(), "Base DN", LocalIdentityProfilePaths.getBaseDn()));
            if (isRegistrationEnabled) {
                this.addValidator((Validator)new NotBlankValidator(ldapDataStoreConfig.getCreatePattern(), "Create Pattern", LocalIdentityProfilePaths.getCreatePattern()));
                this.addValidator((Validator)new NotBlankValidator(ldapDataStoreConfig.getObjectClass(), "Object Class", LocalIdentityProfilePaths.getObjectClass()));
            }
        }

        @Override
        public boolean validate() {
            DataSource dataSource;
            String dataStoreId;
            boolean isValid = super.validate();
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            if (isValid) {
                dataStoreId = this.ldapDataStoreConfig.getDataStoreRef().getId();
                dataSource = dsMgr.getDataSource(dataStoreId);
                String dataStoreRefPath = LocalIdentityProfilePaths.getDataStoreRef();
                if (dataSource == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_not_found, dataStoreRefPath, new Object[]{dataStoreId}));
                    isValid = false;
                } else if (dataSource instanceof LdapDataSource) {
                    boolean isSupported;
                    LdapDataSource ldapDataSource = (LdapDataSource)dataSource;
                    boolean bl = isSupported = ldapDataSource.getLdapType().equals((Object)LdapInfo.LdapType.PingDirectory) || ldapDataSource.getLdapType().equals((Object)LdapInfo.LdapType.UnboundID);
                    if (!isSupported) {
                        String description = ldapDataSource.getLdapType().getDescription();
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_data_store_unsupported_ldap_data_store, dataStoreRefPath, new Object[]{description}));
                        isValid = false;
                    }
                } else {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_data_store_unsupported_data_store_type, dataStoreRefPath, new Object[]{dataSource.getDataSourceType()}));
                    isValid = false;
                }
            }
            if (isValid) {
                dataStoreId = this.ldapDataStoreConfig.getDataStoreRef().getId();
                dataSource = (LdapDataSource)dsMgr.getDataSource(dataStoreId);
                ArrayList<String> availableAttributes = new ArrayList<String>();
                if (this.availableVars != null) {
                    availableAttributes.addAll(this.availableVars);
                }
                List dataStoreAttributes = LocalIdentityStorageManager.getInstance((LdapInfo.LdapType)dataSource.getLdapType()).getAvailableCustomAttributes();
                availableAttributes.addAll(dataStoreAttributes);
                if (StringUtils.isNotBlank((String)this.ldapDataStoreConfig.getBaseDn())) {
                    LdapNameValidator ldapNameValidator = new LdapNameValidator(this.ldapDataStoreConfig.getBaseDn(), availableAttributes, ApiMessageKey.ldap_attribute_source_base_dn_malformed, ApiMessageKey.ldap_attribute_source_base_dn_var_not_found, LocalIdentityProfilePaths.getBaseDn());
                    isValid = this.runValidator((Validator)ldapNameValidator);
                }
                if (StringUtils.isNotBlank((String)this.ldapDataStoreConfig.getCreatePattern())) {
                    LdapNameValidator ldapNameValidator = new LdapNameValidator(this.ldapDataStoreConfig.getCreatePattern(), availableAttributes, ApiMessageKey.local_identity_profile_data_store_create_pattern_malformed, ApiMessageKey.local_identity_profile_data_store_create_pattern_var_not_found, LocalIdentityProfilePaths.getCreatePattern());
                    isValid &= this.runValidator((Validator)ldapNameValidator);
                    if (this.isRegistrationEnabled) {
                        LdapCreatePatternValidator ldapCreatePatternValidator = new LdapCreatePatternValidator(this.ldapDataStoreConfig.getCreatePattern(), availableAttributes, LocalIdentityProfilePaths.getCreatePattern());
                        isValid &= this.runValidator((Validator)ldapCreatePatternValidator);
                    }
                }
            }
            if (isValid && !this.isBypassExternalValidation()) {
                LdapDataSource ldapDataSource;
                String dsId;
                Validator validator = DataStoreAttributeValidator.getInstance(this.ldapDataStoreConfig);
                if (validator != null) {
                    isValid = this.runValidator(validator);
                }
                if (this.isRegistrationEnabled && StringUtils.isNotBlank((String)this.ldapDataStoreConfig.getObjectClass())) {
                    dsId = this.ldapDataStoreConfig.getDataStoreRef().getId();
                    ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(dsId);
                    LdapObjectClassValidator objectClassValidator = LdapObjectClassValidator.getInstance(this.ldapDataStoreConfig.getObjectClass(), ldapDataSource, LocalIdentityProfilePaths.getObjectClass(), false);
                    boolean bl = isValid = isValid && this.runValidator((Validator)objectClassValidator);
                }
                if (this.isRegistrationEnabled && CollectionUtils.isNotEmpty(this.ldapDataStoreConfig.getAuxiliaryObjectClasses())) {
                    dsId = this.ldapDataStoreConfig.getDataStoreRef().getId();
                    ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(dsId);
                    ArrayList<String> auxClassList = new ArrayList<String>();
                    for (String auxObjectClass : this.ldapDataStoreConfig.getAuxiliaryObjectClasses()) {
                        LdapAuxiliaryObjectClassesValidator auxiliaryObjectClassesValidator = LdapAuxiliaryObjectClassesValidator.getInstance(auxClassList, auxObjectClass, ldapDataSource, LocalIdentityProfilePaths.getAuxiliaryObjectClasses(), CollectionUtils.isEmpty(auxClassList));
                        isValid &= this.runValidator((Validator)auxiliaryObjectClassesValidator);
                        auxClassList.add(auxObjectClass);
                    }
                }
            }
            return isValid;
        }

        private boolean runValidator(Validator validator) {
            boolean result = validator.validate();
            if (!result) {
                this.appendErrors(validator.getErrors());
            }
            return result;
        }

        private boolean isBypassExternalValidation() {
            return this.context != null && this.context.isBypassExternalValidation();
        }
    }
}

