/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.localidentity;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.List;
import org.sourceid.saml20.domain.LdapDataSource;

public class LdapAuxiliaryObjectClassesValidator
extends AbstractValidator {
    private final List<String> auxClassList;
    private String auxObjectClass;
    private final String path;
    private final List<String> supportedAuxiliaryObjectClasses;
    private final ApiMessageKey invalidObjectClassKey;
    private static LdapAuxiliaryObjectClassesValidator instance = null;

    public LdapAuxiliaryObjectClassesValidator(List<String> auxClassList, String auxObjectClass, LdapDataSource ldapDataSource, String path, ApiMessageKey message) {
        this.auxClassList = auxClassList;
        this.auxObjectClass = auxObjectClass;
        this.path = path;
        this.supportedAuxiliaryObjectClasses = ldapDataSource.getAuxiliaryObjectClasses();
        this.invalidObjectClassKey = message;
    }

    public boolean validate() {
        if (this.auxClassList.contains(this.auxObjectClass)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_data_store_auxiliary_object_class_duplicate, this.path));
        }
        if (!this.supportedAuxiliaryObjectClasses.contains(this.auxObjectClass)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.invalidObjectClassKey, this.path, new Object[]{this.auxObjectClass}));
        }
        return !this.hasErrors();
    }

    public static LdapAuxiliaryObjectClassesValidator getInstance(List<String> auxClassList, String auxObjectClass, LdapDataSource ldapDataSource, String path, boolean forceNew) {
        ApiMessageKey message = ApiMessageKey.local_identity_profile_data_store_auxiliary_object_class_invalid;
        if (instance == null || forceNew) {
            instance = new LdapAuxiliaryObjectClassesValidator(auxClassList, auxObjectClass, ldapDataSource, path, message);
        } else {
            instance.clearErrors();
            instance.setAuxObjectClass(auxObjectClass);
        }
        return instance;
    }

    public void setAuxObjectClass(String auxObjectClass) {
        this.auxObjectClass = auxObjectClass;
    }
}

