/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.localidentity;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class LdapCreatePatternValidator
extends AbstractValidator {
    private final String createPattern;
    private final Collection<String> availableVars;
    private final ApiMessageKey createPatternRequiredKey;
    private final ApiMessageKey createPatternInvalidKey;
    private final String fieldPath;

    public LdapCreatePatternValidator(String createPattern, Collection<String> availableVars, ApiMessageKey createPatternRequiredKey, ApiMessageKey createPatternInvalidKey, String fieldPath) {
        this.createPattern = createPattern;
        this.availableVars = availableVars;
        this.createPatternRequiredKey = createPatternRequiredKey;
        this.createPatternInvalidKey = createPatternInvalidKey;
        this.fieldPath = fieldPath;
    }

    public LdapCreatePatternValidator(String createPattern, Collection<String> availableVars, String fieldPath) {
        this(createPattern, availableVars, ApiMessageKey.local_identity_profile_data_store_create_pattern_required, ApiMessageKey.local_identity_profile_data_store_create_pattern_malformed, fieldPath);
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.createPattern)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.createPatternRequiredKey, this.fieldPath));
        }
        if (!StringUtils.isBlank((String)this.createPattern) && !LDAPUtil.validateFilter((String)this.createPattern)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.createPatternInvalidKey, this.fieldPath));
        }
        return !this.hasErrors();
    }
}

