/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.localidentity;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.LocalIdentityProfilePaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.localidentity.type.EmailVerificationType;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class LocalIdentityProfileEmailVerificationTypeValidator
extends CompositeValidator {
    private final boolean adminApiValidation;
    private final boolean emailVerificationEnabled;
    private final EmailVerificationType emailVerificationType;
    private final String otpLength;
    private final String otpRetryAttempts;
    private final String allowedOtpCharacterSet;
    private final String otpTimeToLive;
    private final String emailVerificationOtpTemplateName;
    private final String otlTimeToLive;
    private final String requireEmailVerificationTemplateName;
    private final String emailVerificationSentTemplateName;

    private LocalIdentityProfileEmailVerificationTypeValidator(Builder builder) {
        this.adminApiValidation = builder.adminApiValidation;
        this.emailVerificationEnabled = builder.emailVerificationEnabled;
        this.emailVerificationType = builder.emailVerificationType;
        this.otpLength = builder.otpLength;
        this.otpRetryAttempts = builder.otpRetryAttempts;
        this.allowedOtpCharacterSet = builder.allowedOtpCharacterSet;
        this.otpTimeToLive = builder.otpTimeToLive;
        this.emailVerificationOtpTemplateName = builder.emailVerificationOtpTemplateName;
        this.otlTimeToLive = builder.otlTimeToLive;
        this.requireEmailVerificationTemplateName = builder.requireEmailVerificationTemplateName;
        this.emailVerificationSentTemplateName = builder.emailVerificationSentTemplateName;
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validateEmailVerificationTypeConfiguration();
        return !this.hasErrors();
    }

    private void validateEmailVerificationTypeConfiguration() {
        if (!this.emailVerificationEnabled) {
            if (this.emailVerificationType != null && this.adminApiValidation) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_email_verification_type_not_allowed, LocalIdentityProfilePaths.getEmailVerificationType()));
            }
            this.checkOtpFieldsBlank();
            if (StringUtils.isNotBlank((String)this.otlTimeToLive) && this.adminApiValidation) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_otl_time_to_live_not_allowed, LocalIdentityProfilePaths.getOtlTimeToLive()));
            }
        } else if (this.emailVerificationType != null && this.emailVerificationType.equals((Object)EmailVerificationType.OTP)) {
            if (!(this.otpLength == null || ValidationUtil.isValidNonNegInt((String)this.otpLength) && Integer.parseInt(this.otpLength) >= 5 && Integer.parseInt(this.otpLength) <= 100)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_otp_length_invalid, LocalIdentityProfilePaths.getOtpLength()));
            }
            if (!(this.otpRetryAttempts == null || ValidationUtil.isValidNonNegInt((String)this.otpRetryAttempts) && Integer.parseInt(this.otpRetryAttempts) >= 1 && Integer.parseInt(this.otpRetryAttempts) <= 100)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_otp_retry_attempts_invalid, LocalIdentityProfilePaths.getOtpRetryAttempts()));
            }
            if (!(this.allowedOtpCharacterSet == null || ValidationUtil.isUniqueCharacters((String)this.allowedOtpCharacterSet) && this.allowedOtpCharacterSet.trim().length() >= 10)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_allowed_otp_character_set_invalid, LocalIdentityProfilePaths.getAllowedOtpCharacterSet()));
            }
            if (!(this.otpTimeToLive == null || ValidationUtil.isValidNonNegInt((String)this.otpTimeToLive) && Integer.parseInt(this.otpTimeToLive) >= 1 && Integer.parseInt(this.otpTimeToLive) <= 9999)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_otp_time_to_live_invalid, LocalIdentityProfilePaths.getOtpTimeToLive()));
            }
            if (StringUtils.isBlank((String)this.emailVerificationOtpTemplateName) && !this.adminApiValidation) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_otp_template_required, LocalIdentityProfilePaths.getEmailVerificationOtpTemplate()));
            }
            if (this.otlTimeToLive != null && this.adminApiValidation) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_otl_time_to_live_not_allowed, LocalIdentityProfilePaths.getOtlTimeToLive()));
            }
            if (StringUtils.isNotBlank((String)this.requireEmailVerificationTemplateName) && this.adminApiValidation) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_require_verified_email_template_not_allowed, LocalIdentityProfilePaths.getRequireVerifiedEmailTemplate()));
            }
            if (StringUtils.isNotBlank((String)this.emailVerificationSentTemplateName) && this.adminApiValidation) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_sent_template_not_allowed, LocalIdentityProfilePaths.getEmailVerificationSentTemplate()));
            }
        } else {
            if (!(this.otlTimeToLive == null || ValidationUtil.isValidNonNegInt((String)this.otlTimeToLive) && Integer.parseInt(this.otlTimeToLive) >= 1 && Integer.parseInt(this.otlTimeToLive) <= 9999)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_config_otl_time_to_live_invalid, LocalIdentityProfilePaths.getOtlTimeToLive()));
            }
            this.checkOtpFieldsBlank();
        }
    }

    private void checkOtpFieldsBlank() {
        if (this.adminApiValidation) {
            if (StringUtils.isNotBlank((String)this.otpLength)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_otp_length_not_allowed, LocalIdentityProfilePaths.getOtpLength()));
            }
            if (StringUtils.isNotBlank((String)this.otpRetryAttempts)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_otp_retry_attempts_not_allowed, LocalIdentityProfilePaths.getOtpRetryAttempts()));
            }
            if (StringUtils.isNotBlank((String)this.allowedOtpCharacterSet)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_allowed_otp_character_set_not_allowed, LocalIdentityProfilePaths.getAllowedOtpCharacterSet()));
            }
            if (StringUtils.isNotBlank((String)this.otpTimeToLive)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_otp_time_to_live_not_allowed, LocalIdentityProfilePaths.getOtpTimeToLive()));
            }
            if (StringUtils.isNotBlank((String)this.emailVerificationOtpTemplateName)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.local_identity_profile_email_verification_otp_template_not_allowed, LocalIdentityProfilePaths.getEmailVerificationOtpTemplate()));
            }
        }
    }

    public static class Builder {
        private boolean adminApiValidation;
        private boolean emailVerificationEnabled;
        private EmailVerificationType emailVerificationType;
        private String otpLength;
        private String otpRetryAttempts;
        private String allowedOtpCharacterSet;
        private String otpTimeToLive;
        private String emailVerificationOtpTemplateName;
        private String otlTimeToLive;
        private String requireEmailVerificationTemplateName;
        private String emailVerificationSentTemplateName;

        public Builder setAdminApiValidation(boolean adminApiValidation) {
            this.adminApiValidation = adminApiValidation;
            return this;
        }

        public Builder setEmailVerificationEnabled(boolean emailVerificationEnabled) {
            this.emailVerificationEnabled = emailVerificationEnabled;
            return this;
        }

        public Builder setEmailVerificationType(EmailVerificationType emailVerificationType) {
            this.emailVerificationType = emailVerificationType;
            return this;
        }

        public Builder setOtpLength(String otpLength) {
            this.otpLength = otpLength;
            return this;
        }

        public Builder setOtpRetryAttempts(String otpRetryAttempts) {
            this.otpRetryAttempts = otpRetryAttempts;
            return this;
        }

        public Builder setAllowedOtpCharacterSet(String allowedOtpCharacterSet) {
            this.allowedOtpCharacterSet = allowedOtpCharacterSet;
            return this;
        }

        public Builder setOtpTimeToLive(String otpTimeToLive) {
            this.otpTimeToLive = otpTimeToLive;
            return this;
        }

        public Builder setEmailVerificationOtpTemplateName(String emailVerificationOtpTemplateName) {
            this.emailVerificationOtpTemplateName = emailVerificationOtpTemplateName;
            return this;
        }

        public Builder setOtlTimeToLive(String otlTimeToLive) {
            this.otlTimeToLive = otlTimeToLive;
            return this;
        }

        public Builder setRequireEmailVerificationTemplateName(String requireEmailVerificationTemplateName) {
            this.requireEmailVerificationTemplateName = requireEmailVerificationTemplateName;
            return this;
        }

        public Builder setEmailVerificationSentTemplateName(String emailVerificationSentTemplateName) {
            this.emailVerificationSentTemplateName = emailVerificationSentTemplateName;
            return this;
        }

        public LocalIdentityProfileEmailVerificationTypeValidator build() {
            return new LocalIdentityProfileEmailVerificationTypeValidator(this);
        }
    }
}

