/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AdditionalKeySet;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.oauth.JwksSigningKeySetPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.oauth.OidcOAuthSigningKeyValidator;
import com.pingidentity.admin.api.validator.simple.DuplicateValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.JwksSigningInstanceSettings;
import org.sourceid.oauth20.domain.JwksSigningKeySetsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class JwksSigningKeysValidator
extends CompositeValidator {
    private static final JwksSigningKeySetsManager jwksSigningKeySetsManager = MgmtFactory.getJWKSSigningKeySetsManager();
    private final AdditionalKeySet jwksKeySet;
    private static final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final boolean isBulkRequest;

    public JwksSigningKeysValidator(AdditionalKeySet jwksKeySet, ValidatorContext context) {
        boolean isCreate = !context.isUpdateRequest();
        this.jwksKeySet = jwksKeySet;
        this.addIdNameValidators(jwksKeySet, isCreate);
        this.addSigningKeysValidator(jwksKeySet);
        this.isBulkRequest = context.isBulkConfigRequest();
    }

    private void addSigningKeysValidator(AdditionalKeySet jwksKeySet) {
        if (jwksKeySet.getSigningKeys() == null) {
            this.appendError(errorFactory.create(ApiMessageKey.field_required, JwksSigningKeySetPaths.getSigningKeys(), new Object[]{"signing keys"}));
        } else {
            this.addValidator((Validator)new OidcOAuthSigningKeyValidator(jwksKeySet.getSigningKeys()));
        }
    }

    private void addIdNameValidators(AdditionalKeySet jwksKeySet, boolean isCreate) {
        String id = jwksKeySet.getId();
        String existingKeyName = null;
        IdValidator idValidator = new IdValidator(id, true, false, 0, 33, JwksSigningKeySetPaths.getId());
        idValidator.setBlankIdMessageKey(ApiMessageKey.field_blank);
        idValidator.setBlankIdMessageParams("id");
        this.addValidator((Validator)idValidator);
        if (isCreate) {
            if (jwksSigningKeySetsManager.getKeySet(id) != null) {
                Set ids = jwksSigningKeySetsManager.getAllKeySets().stream().map(JwksSigningInstanceSettings::getId).collect(Collectors.toSet());
                this.addValidator((Validator)new DuplicateValidator<String>(id, JwksSigningKeySetPaths.getId(), ApiMessageKey.oauth_jwks_additional_key_set_duplicate_id, ids));
            }
        } else {
            existingKeyName = jwksSigningKeySetsManager.getKeySet(id).getName();
        }
        String name = jwksKeySet.getName();
        this.addValidator((Validator)new NotBlankValidator(name, "name", JwksSigningKeySetPaths.getName()));
        Set existingNames = jwksSigningKeySetsManager.getAllKeySets().stream().map(JwksSigningInstanceSettings::getName).collect(Collectors.toSet());
        if (jwksKeySet.getName() != null && jwksKeySet.getName().equals(existingKeyName)) {
            existingNames.remove(jwksKeySet.getName());
        }
        this.addValidator((Validator)new DuplicateValidator<String>(name, JwksSigningKeySetPaths.getName(), ApiMessageKey.oauth_jwks_additional_key_set_duplicate_name, existingNames));
    }

    @Override
    public boolean validate() {
        super.validate();
        if (!this.hasErrors()) {
            if (this.jwksKeySet.getIssuers() == null || this.jwksKeySet.getIssuers().isEmpty()) {
                this.appendError(errorFactory.create(ApiMessageKey.field_required, JwksSigningKeySetPaths.getIssuers(), new Object[]{"issuers"}));
            } else {
                Set validIssuers = MgmtFactory.getOAuthIssuerManager().getIds();
                int index = 0;
                for (ResourceLink inputIssuer : this.jwksKeySet.getIssuers()) {
                    if (StringUtils.isEmpty((String)inputIssuer.getId())) {
                        this.appendError(errorFactory.create(ApiMessageKey.field_required, JwksSigningKeySetPaths.getIssuers(index), new Object[]{"issuer identifier"}));
                        continue;
                    }
                    if (this.isBulkRequest) continue;
                    if (!validIssuers.contains(inputIssuer.getId())) {
                        this.appendError(errorFactory.create(ApiMessageKey.oauth_jwks_additional_key_set_invalid_issuer_id, JwksSigningKeySetPaths.getIssuers(index), new Object[]{inputIssuer.getId()}));
                        continue;
                    }
                    for (JwksSigningInstanceSettings jwksSigningInstanceSettings : jwksSigningKeySetsManager.getAllKeySets()) {
                        if (!jwksSigningInstanceSettings.getIssuerIds().contains(inputIssuer.getId()) || jwksSigningInstanceSettings.getId().equals(this.jwksKeySet.getId())) continue;
                        this.appendError(errorFactory.create(ApiMessageKey.oauth_jwks_additional_key_set_duplicate_issuer_id, JwksSigningKeySetPaths.getIssuers(index), new Object[]{inputIssuer.getId(), jwksSigningInstanceSettings.getId()}));
                    }
                }
            }
        }
        return !this.hasErrors();
    }
}

