/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth;

import com.pingidentity.admin.api.model.OAuthOidcKeysSettings;
import com.pingidentity.admin.api.model.SigningKeys;
import com.pingidentity.admin.api.model.fieldpaths.oauth.JwksSigningKeySetPaths;
import com.pingidentity.admin.api.validator.OAuthOidcKeysValidator;

public class OidcOAuthSigningKeyValidator
extends OAuthOidcKeysValidator {
    public OidcOAuthSigningKeyValidator(SigningKeys signingKeys) {
        super(OidcOAuthSigningKeyValidator.populateOAuthOidcKeySet(signingKeys), true);
    }

    private static OAuthOidcKeysSettings populateOAuthOidcKeySet(SigningKeys signingKeys) {
        OAuthOidcKeysSettings oAuthOidcKeysSettings = new OAuthOidcKeysSettings();
        oAuthOidcKeysSettings.setP256ActiveCertRef(signingKeys.getP256ActiveCertRef());
        oAuthOidcKeysSettings.setP256PreviousCertRef(signingKeys.getP256PreviousCertRef());
        oAuthOidcKeysSettings.setP256PublishX5cParameter(signingKeys.isP256PublishX5cParameter());
        oAuthOidcKeysSettings.setP256ActiveKeyId(signingKeys.getP256ActiveKeyId());
        oAuthOidcKeysSettings.setP256PreviousKeyId(signingKeys.getP256PreviousKeyId());
        oAuthOidcKeysSettings.setP384ActiveCertRef(signingKeys.getP384ActiveCertRef());
        oAuthOidcKeysSettings.setP384PreviousCertRef(signingKeys.getP384PreviousCertRef());
        oAuthOidcKeysSettings.setP384PublishX5cParameter(signingKeys.isP384PublishX5cParameter());
        oAuthOidcKeysSettings.setP384ActiveKeyId(signingKeys.getP384ActiveKeyId());
        oAuthOidcKeysSettings.setP384PreviousKeyId(signingKeys.getP384PreviousKeyId());
        oAuthOidcKeysSettings.setP521ActiveCertRef(signingKeys.getP521ActiveCertRef());
        oAuthOidcKeysSettings.setP521PreviousCertRef(signingKeys.getP521PreviousCertRef());
        oAuthOidcKeysSettings.setP521PublishX5cParameter(signingKeys.isP521PublishX5cParameter());
        oAuthOidcKeysSettings.setP521ActiveKeyId(signingKeys.getP521ActiveKeyId());
        oAuthOidcKeysSettings.setP521PreviousKeyId(signingKeys.getP521PreviousKeyId());
        oAuthOidcKeysSettings.setRsaActiveCertRef(signingKeys.getRsaActiveCertRef());
        oAuthOidcKeysSettings.setRsaPreviousCertRef(signingKeys.getRsaPreviousCertRef());
        oAuthOidcKeysSettings.setRsaPublishX5cParameter(signingKeys.isRsaPublishX5cParameter());
        oAuthOidcKeysSettings.setRsaActiveKeyId(signingKeys.getRsaActiveKeyId());
        oAuthOidcKeysSettings.setRsaPreviousKeyId(signingKeys.getRsaPreviousKeyId());
        oAuthOidcKeysSettings.setRsaAlgorithmPreviousKeyIds(signingKeys.getRsaAlgorithmPreviousKeyIds());
        oAuthOidcKeysSettings.setRsaAlgorithmActiveKeyIds(signingKeys.getRsaAlgorithmActiveKeyIds());
        return oAuthOidcKeysSettings;
    }

    @Override
    protected String getRsaActiveCertPath() {
        return JwksSigningKeySetPaths.getRsaActiveCertPath();
    }

    @Override
    protected String getApiKeyMessageRsaPreviousCertPath() {
        return JwksSigningKeySetPaths.getRsaPreviousCertPath();
    }

    @Override
    protected String getP521PreviousCertPath() {
        return JwksSigningKeySetPaths.getP521PreviousCertPath();
    }

    @Override
    protected String getP521ActiveCertPath() {
        return JwksSigningKeySetPaths.getP521ActiveCertPath();
    }

    @Override
    protected String getP384PreviousCertPath() {
        return JwksSigningKeySetPaths.getP384PreviousCertPath();
    }

    @Override
    protected String getP384ActiveCertPath() {
        return JwksSigningKeySetPaths.getP384ActiveCertPath();
    }

    @Override
    protected String getP256ActiveCertPath() {
        return JwksSigningKeySetPaths.getP256ActiveCertPath();
    }

    @Override
    protected String getP256PreviousCertPath() {
        return JwksSigningKeySetPaths.getP256PreviousCertPath();
    }
}

