/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.exchange.TokenExchangeGeneratorGroupPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class GeneratorGroupResourceUrisValidator
extends AbstractValidator {
    private static final ApiMessageKey DUPLICATE_MESSAGE_KEY = ApiMessageKey.token_exchange_generator_group_resource_url_duplicate;
    private static final ApiMessageKey INVALID_RESOURCE_URI = ApiMessageKey.token_exchange_generator_group_invalid_resource_url;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final List<String> resourceUris;

    public GeneratorGroupResourceUrisValidator(List<String> resourceUris) {
        this.resourceUris = resourceUris;
    }

    public boolean validate() {
        ArrayList<String> visitedResourceUris = new ArrayList<String>(this.resourceUris.size());
        int index = 0;
        for (String resourceUri : this.resourceUris) {
            String resourceUriPath = TokenExchangeGeneratorGroupPaths.getResourceUriPath(index++);
            if (visitedResourceUris.contains(resourceUri)) {
                this.appendError(this.errorFactory.create(DUPLICATE_MESSAGE_KEY, resourceUriPath));
                continue;
            }
            if (this.isValidUri(resourceUri)) {
                visitedResourceUris.add(resourceUri);
                continue;
            }
            this.appendError(this.errorFactory.create(INVALID_RESOURCE_URI, resourceUriPath));
        }
        return !this.hasErrors();
    }

    private boolean isValidUri(String resourceUri) {
        try {
            URI uri = new URI(resourceUri);
            if (uri.isAbsolute() && StringUtils.isBlank((String)uri.getFragment())) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }
}

