/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.oauth.exchange.TokenExchangeGeneratorSettingsPath;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeGeneratorSettings;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorSettingsValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import org.sourceid.oauth20.exchange.domain.TokenExchangeGeneratorPolicies;

public class GeneratorSettingsValidator
extends CompositeValidator {
    private static final String DEFAULT_GENERATOR_GROUP_REF_PATH = TokenExchangeGeneratorSettingsPath.getDefaultGeneratorGroupRef();

    public GeneratorSettingsValidator(TokenExchangeGeneratorPolicies domain, TokenExchangeGeneratorSettings settings) {
        if (domain.getPolicies() != null && !domain.getPolicies().isEmpty()) {
            if (settings == null) {
                this.addValidator((Validator)new NotNullValidator(null, "Setting", null));
            } else {
                ResourceLink defaultGeneratorGroupRef = settings.getDefaultGeneratorGroupRef();
                if (defaultGeneratorGroupRef != null) {
                    this.addValidator((Validator)new ResourceIdValidator(defaultGeneratorGroupRef, "Default group reference", DEFAULT_GENERATOR_GROUP_REF_PATH));
                    this.addValidator((Validator)new ProcessorSettingsValidator.ResourceLinkIntegrityValidator<TokenExchangeGeneratorPolicies>(defaultGeneratorGroupRef, domain, "default instance", DEFAULT_GENERATOR_GROUP_REF_PATH));
                } else {
                    this.addValidator((Validator)new NotNullValidator(null, "Default group reference", DEFAULT_GENERATOR_GROUP_REF_PATH));
                }
            }
        }
    }
}

