/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.exchange.TokenExchangeGeneratorGroupPaths;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeGeneratorGroup;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeGeneratorMapping;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.oauth.exchange.GeneratorGroupBasicsValidator;
import com.pingidentity.admin.api.validator.oauth.exchange.GeneratorGroupTokenTypeValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.Set;
import org.sourceid.oauth20.exchange.manager.TokenExchangeGeneratorPolicyManager;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;

public class TokenExchangeGeneratorGroupValidator
extends CompositeValidator {
    private TokenExchangeGeneratorGroupValidator(TokenExchangeGeneratorPolicyManager policyMgr, TokenGeneratorManager tokenGeneratorMgr, boolean isCreate, TokenExchangeGeneratorGroup payload, TokenExchangeGeneratorGroup savedInstance) {
        Set ids = policyMgr.getTokenExchangeGeneratorPolicies().getPolicyIds();
        Set names = policyMgr.getTokenExchangeGeneratorPolicies().getPolicyNames();
        String currentName = savedInstance != null ? savedInstance.getName() : null;
        this.addValidator((Validator)new GeneratorGroupBasicsValidator(payload.getId(), payload.getName(), isCreate, ids, names, currentName, payload.getResourceUris()));
        int defaultMappingCount = 0;
        ArrayList<GeneratorGroupTokenTypeValidator.TokenTypeTokenGeneratorPair> pairs = new ArrayList<GeneratorGroupTokenTypeValidator.TokenTypeTokenGeneratorPair>();
        String defaultRequestedTokenType = null;
        for (TokenExchangeGeneratorMapping mapping : payload.getGeneratorMappings()) {
            if (mapping.isDefaultMapping()) {
                ++defaultMappingCount;
                defaultRequestedTokenType = mapping.getRequestedTokenType();
            }
            String requestedTokenType = mapping.getRequestedTokenType();
            String tokenGeneratorId = mapping.getTokenGenerator() != null ? mapping.getTokenGenerator().getId() : "";
            pairs.add(new GeneratorGroupTokenTypeValidator.TokenTypeTokenGeneratorPair(requestedTokenType, tokenGeneratorId));
        }
        if (defaultMappingCount > 1) {
            this.addValidator((Validator)new InvalidDefaultMappingValidator());
        }
        this.addValidator((Validator)new GeneratorGroupTokenTypeValidator(tokenGeneratorMgr, defaultRequestedTokenType, pairs));
    }

    public static TokenExchangeGeneratorGroupValidator validateCreate(TokenExchangeGeneratorPolicyManager policyMgr, TokenGeneratorManager tokenGeneratorMgr, TokenExchangeGeneratorGroup payload) {
        return new TokenExchangeGeneratorGroupValidator(policyMgr, tokenGeneratorMgr, true, payload, null);
    }

    public static TokenExchangeGeneratorGroupValidator validateUpdate(TokenExchangeGeneratorPolicyManager policyMgr, TokenGeneratorManager tokenGeneratorMgr, TokenExchangeGeneratorGroup payload, TokenExchangeGeneratorGroup savedInstance) {
        return new TokenExchangeGeneratorGroupValidator(policyMgr, tokenGeneratorMgr, false, payload, savedInstance);
    }

    private static class InvalidDefaultMappingValidator
    extends AbstractValidator {
        private ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

        private InvalidDefaultMappingValidator() {
        }

        public boolean validate() {
            this.appendError(this.errorFactory.create(ApiMessageKey.token_exchange_generator_group_token_type_mapping_default_required, TokenExchangeGeneratorGroupPaths.getMappingsPath()));
            return !this.hasErrors();
        }
    }
}

