/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.exchange.TokenExchangeProcessorPolicyPaths;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorAttribute;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorMappingTokenTypeValidator;
import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorPolicyBasicsValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorAttributeContract;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class TokenExchangeProcessorPolicyValidator
extends CompositeValidator {
    private static final String ATTRIBUTE_CONTRACT_PATH = TokenExchangeProcessorPolicyPaths.getAttributeContract();
    private static final String PROCESSOR_MAPPINGS_PATH = TokenExchangeProcessorPolicyPaths.getProcessorMappings();
    private UniqueEntriesValidator.UniqueKeyGetter<TokenExchangeProcessorMapping> uniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<TokenExchangeProcessorMapping>(){

        @Override
        public String getKey(TokenExchangeProcessorMapping mapping) {
            Object key = mapping.getSubjectTokenType();
            if (StringUtils.isNotBlank((String)mapping.getActorTokenType())) {
                key = (String)key + "|" + mapping.getActorTokenType();
            }
            return key;
        }
    };

    public TokenExchangeProcessorPolicyValidator(TokenExchangeProcessorPolicyManager policyManager, TokenExchangeProcessorPolicy policy, TokenExchangeProcessorPolicy currentInstance, TokenProcessorManager tokenProcessorMgr, ValidatorContext context) {
        boolean isCreate = !context.isUpdateRequest();
        Set policyIds = policyManager.getTokenExchangeProcessorPolicies().getPolicyIds();
        Set policyNames = policyManager.getTokenExchangeProcessorPolicies().getPolicyNames();
        String currentName = currentInstance != null ? currentInstance.getName() : null;
        this.addValidator((Validator)new ProcessorPolicyBasicsValidator(policy.getId(), policy.getName(), isCreate, policyIds, policyNames, currentName));
        this.addAttributeContractValidator(policy);
        this.addValidator((Validator)new UniqueEntriesValidator<TokenExchangeProcessorMapping>(this.uniqueKeyGetter, policy.getProcessorMappings(), PROCESSOR_MAPPINGS_PATH, ApiMessageKey.token_exchange_processor_mapping_exists, ApiMessageKey.token_exchange_processor_one_mapping_required));
        int index = 0;
        for (TokenExchangeProcessorMapping mapping : policy.getProcessorMappings()) {
            this.addValidator((Validator)new ProcessorMappingTokenTypeValidator(context, tokenProcessorMgr, mapping, policy, index++));
        }
    }

    private void addAttributeContractValidator(TokenExchangeProcessorPolicy policy) {
        List coreAttributes = new TokenExchangeProcessorAttributeContract().getImmutableAttributeNames().stream().map(name -> {
            TokenExchangeProcessorAttribute coreAttribute = new TokenExchangeProcessorAttribute();
            coreAttribute.setName((String)name);
            return coreAttribute;
        }).collect(Collectors.toList());
        ArrayList<TokenExchangeProcessorAttribute> extendedAttributes = new ArrayList<TokenExchangeProcessorAttribute>(policy.getAttributeContract().getExtendedAttributes());
        this.addValidator((Validator)new AttributeContractValidator<TokenExchangeProcessorAttribute>(coreAttributes, extendedAttributes, ATTRIBUTE_CONTRACT_PATH));
    }
}

