/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.sessions;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.sessions.SessionQuotaPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.session.quotas.SessionQuotaBehavior;

public class SessionQuotaValidator
extends AbstractValidator {
    private final Boolean enabled;
    private final Integer activeSessionLimit;
    private final SessionQuotaBehavior quotaLimitBehavior;

    private SessionQuotaValidator(Builder builder) {
        this.enabled = builder.enabled;
        this.activeSessionLimit = builder.activeSessionLimit;
        this.quotaLimitBehavior = builder.quotaLimitBehavior;
    }

    public boolean validate() {
        if (this.enabled == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.session_quota_missing_enabled, SessionQuotaPaths.enabled()));
            return false;
        }
        if (this.enabled.booleanValue()) {
            if (this.activeSessionLimit == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.session_quota_missing_active_session_limit, SessionQuotaPaths.activeSessionLimit()));
            } else if (this.activeSessionLimit < 1 || this.activeSessionLimit > 1000) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.session_quota_invalid_active_session_limit, SessionQuotaPaths.activeSessionLimit(), new Object[]{this.activeSessionLimit}));
            }
            if (this.quotaLimitBehavior == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.session_quota_missing_quota_limit_behavior, SessionQuotaPaths.quotaLimitBehavior()));
            }
        }
        return !this.hasErrors();
    }

    public static class Builder {
        Boolean enabled;
        Integer activeSessionLimit;
        SessionQuotaBehavior quotaLimitBehavior;

        public Builder setEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setActiveSessionLimit(Integer activeSessionLimit) {
            this.activeSessionLimit = activeSessionLimit;
            return this;
        }

        public Builder setQuotaLimitBehavior(SessionQuotaBehavior quotaLimitBehavior) {
            this.quotaLimitBehavior = quotaLimitBehavior;
            return this;
        }

        public SessionQuotaValidator build() {
            return new SessionQuotaValidator(this);
        }
    }
}

