/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.simple;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public final class IntegerValidator
extends AbstractValidator {
    private final String value;
    private final String friendlyName;
    private final String fieldPath;
    private final boolean required;
    private final Integer minValue;
    private final Integer maxValue;

    public IntegerValidator(String value, String friendlyName, String fieldPath, boolean required, Integer minValue, Integer maxValue) {
        if (minValue == null && maxValue != null) {
            throw new AssertionError((Object)"Less then validation is not supported");
        }
        this.value = value;
        this.friendlyName = friendlyName;
        this.fieldPath = fieldPath;
        this.required = required;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public boolean validate() {
        if (this.required && StringUtils.isBlank((String)this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, this.fieldPath, new Object[]{this.friendlyName}));
            return false;
        }
        if (this.minValue == null && this.maxValue == null && !ValidationUtil.isValidInt((String)this.value)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.integer_value_invalid, this.fieldPath, new Object[]{this.friendlyName}));
        }
        if (this.minValue != null && this.maxValue == null && !ValidationUtil.isValidInt((String)this.value, (int)this.minValue)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.integer_value_not_greater_or_equal_to, this.fieldPath, new Object[]{this.friendlyName, this.minValue}));
        }
        if (this.minValue != null && this.maxValue != null && !ValidationUtil.isValidInt((String)this.value, (int)this.minValue, (int)this.maxValue)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.integer_value_not_in_range, this.fieldPath, new Object[]{this.friendlyName, this.minValue, this.maxValue}));
        }
        return !this.hasErrors();
    }
}

