/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.simple;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.List;

public class ListSizeValidator<T>
extends AbstractValidator {
    private final List<T> list;
    private final int maxSize;
    private final int minSize;
    private final ApiMessageKey errorKey;

    public ListSizeValidator(List<T> list, int maxSize, int minSize, ApiMessageKey errorKey) {
        this.list = list;
        this.maxSize = maxSize;
        this.minSize = minSize;
        this.errorKey = errorKey;
    }

    public boolean validate() {
        if (this.list == null) {
            ValidationError error = ValidationErrorFactory.getInstance().create(this.errorKey, "0", new Object[]{0, this.minSize, this.maxSize});
            this.appendError(error);
        } else if (this.list.size() < this.minSize || this.list.size() > this.maxSize) {
            ValidationError error = ValidationErrorFactory.getInstance().create(this.errorKey, "0", new Object[]{String.valueOf(this.list.size()), this.minSize, this.maxSize});
            this.appendError(error);
        }
        return !this.hasErrors();
    }
}

