/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.structures;

import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.validator.structures.FragmentInfo;
import com.pingidentity.admin.api.validator.structures.UpstreamSources;
import java.util.Collections;
import java.util.List;

public class ActionValidatorInfo {
    private final String rootFieldPath;
    private final PolicyAction action;
    private final PolicyAction parentNodeAction;
    private final List<AuthenticationPolicyTreeNode> children;
    private final boolean hasAuthnSourceAncestor;
    private final List<String> trackedParams;
    private final boolean hasSuccessInPath;
    private final UpstreamSources upstreamSources;
    private FragmentInfo fragmentInfo;

    private ActionValidatorInfo(String rootFieldPath, PolicyAction action, List<AuthenticationPolicyTreeNode> children, PolicyAction parentNodeAction, boolean hasAuthnSourceAncestor, List<String> trackedParams, boolean hasSuccessInPath, UpstreamSources upstreamSources, FragmentInfo fragmentInfo) {
        this.rootFieldPath = rootFieldPath;
        this.action = action;
        this.parentNodeAction = parentNodeAction;
        this.children = children;
        this.hasAuthnSourceAncestor = hasAuthnSourceAncestor;
        this.trackedParams = trackedParams;
        this.hasSuccessInPath = hasSuccessInPath;
        this.upstreamSources = upstreamSources;
        this.fragmentInfo = fragmentInfo;
    }

    public String getRootFieldPath() {
        return this.rootFieldPath;
    }

    public PolicyAction getAction() {
        return this.action;
    }

    public PolicyAction getParentNodeAction() {
        return this.parentNodeAction;
    }

    public List<AuthenticationPolicyTreeNode> getChildren() {
        return this.children;
    }

    public boolean hasAuthnSourceAncestor() {
        return this.hasAuthnSourceAncestor;
    }

    public List<String> getTrackedParams() {
        return Collections.unmodifiableList(this.trackedParams);
    }

    public boolean hasSuccessInPath() {
        return this.hasSuccessInPath;
    }

    public UpstreamSources getUpstreamSources() {
        return this.upstreamSources;
    }

    public FragmentInfo getFragmentInfo() {
        return this.fragmentInfo;
    }

    public boolean isFragmentPolicy() {
        return this.fragmentInfo != null;
    }

    public static class ActionValidatorInfoBuilder {
        private final String rootFieldPath;
        private final PolicyAction action;
        private final PolicyAction parentNodeAction;
        private final List<AuthenticationPolicyTreeNode> children;
        private final boolean hasAuthnSourceAncestor;
        private List<String> trackedParams;
        private boolean hasSuccessInPath;
        private UpstreamSources upstreamSources;
        private FragmentInfo fragmentInfo;

        public ActionValidatorInfoBuilder(String rootFieldPath, PolicyAction action, List<AuthenticationPolicyTreeNode> children, PolicyAction parentNodeAction, boolean hasAuthnSourceAncestor) {
            this.rootFieldPath = rootFieldPath;
            this.action = action;
            this.parentNodeAction = parentNodeAction;
            this.children = children;
            this.hasAuthnSourceAncestor = hasAuthnSourceAncestor;
        }

        public void setTrackedParams(List<String> trackedParams) {
            this.trackedParams = trackedParams;
        }

        public void setHasSuccessInPath(boolean hasSuccessInPath) {
            this.hasSuccessInPath = hasSuccessInPath;
        }

        public void setUpstreamSources(UpstreamSources upstreamSources) {
            this.upstreamSources = upstreamSources;
        }

        public void setFragmentInfo(FragmentInfo fragmentInfo) {
            this.fragmentInfo = fragmentInfo;
        }

        public ActionValidatorInfo build() {
            return new ActionValidatorInfo(this.rootFieldPath, this.action, this.children, this.parentNodeAction, this.hasAuthnSourceAncestor, this.trackedParams, this.hasSuccessInPath, this.upstreamSources, this.fragmentInfo);
        }
    }
}

